/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.dailysummary.provider;

import ar.com.fdvs.dj.core.layout.ClassicLayoutManager;
import ar.com.fdvs.dj.core.layout.LayoutManager;
import ar.com.fdvs.dj.domain.builders.DJBuilderException;
import au.com.ordermate.persistence.PersistenceManager;
import java.util.List;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import ordermate.OrderMate;
import ordermate.database.reports.dailysummary.DailyVoucherSummaryReport;
import ordermate.database.reports.dailysummary.DailyVoucherSummaryReportCompiler;
import ordermate.database.reports.dailysummary.provider.AbstractDailySubReportProvider;
import ordermate.database.reports.dailysummary.provider.DailySummaryReportProvider;
import ordermate.database.searchers.reports.dailysummary.DailyVoucherSummaryReportSearcher;
import ordermate.reports.dynamicjasper.ReportBuilder;
import ordermate.reports.impl.GenericBiListTableModel;

class DailySummaryVoucherProvider
extends AbstractDailySubReportProvider {
    private static final String VOUCHER_SUMMARY = "DAILY_VOUCHER_ACTIVITY";

    DailySummaryVoucherProvider(DailySummaryReportProvider me) {
        super(me);
    }

    @Override
    void addReport(ReportBuilder superBuilder) {
        this.addVoucherSubReport(superBuilder);
    }

    private void addVoucherSubReport(ReportBuilder superBuilder) {
        DailyVoucherSummaryReportSearcher voucherSearcher = this.superProvider.getSearcher().getVoucherSearcher();
        List<DailyVoucherSummaryReport> topupsReports = voucherSearcher.search();
        List<DailyVoucherSummaryReport> topupReversalsReports = PersistenceManager.getObjectList(DailyVoucherSummaryReport.class, voucherSearcher.getTopupReversalsQuery().toString());
        List<DailyVoucherSummaryReport> redeemsReports = PersistenceManager.getObjectList(DailyVoucherSummaryReport.class, voucherSearcher.getRedeemsQuery().toString());
        List<DailyVoucherSummaryReport> redeemReversalsReports = PersistenceManager.getObjectList(DailyVoucherSummaryReport.class, voucherSearcher.getRedeemReversalsQuery().toString());
        DailyVoucherSummaryReportCompiler compiler = new DailyVoucherSummaryReportCompiler(topupsReports, topupReversalsReports, redeemsReports, redeemReversalsReports);
        this.superProvider.getParameters().put(VOUCHER_SUMMARY, new JRTableModelDataSource(new GenericBiListTableModel(compiler.getColumnNames(), compiler.getReportData())));
        try {
            superBuilder.getReportBuilder().addConcatenatedReport(this.createSubReportBuilder("Daily Voucher Activity", false, compiler.getColumnNames()).buildJasperReport(), (LayoutManager)new ClassicLayoutManager(), VOUCHER_SUMMARY, 0, 10);
        }
        catch (DJBuilderException ex) {
            OrderMate.LOG.error("Cannot instantiate voucher top ups/redeems subreport :", (Throwable)ex);
        }
    }
}

