/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.debtor;

import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentSummaryObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.util.Price;
import java.math.BigDecimal;
import java.util.Date;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.group.DebtorGroup;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemQuantity;

public class DebtorSalesItemReport
extends PersistentSummaryObject {
    public static final Props Properties = new Props();
    private Reference<AbstractDebtor> debtor;
    private Reference<SalesItemQuantity> salesItemQuantity;
    private transient Price cogs;
    private transient Price totalEx;

    public DebtorSalesItemReport() {
        this.debtor = this.createReference(DebtorSalesItemReport.Properties.DEBTOR);
        this.salesItemQuantity = this.createReference(DebtorSalesItemReport.Properties.SALES_ITEM_QUANTITY);
    }

    public AbstractDebtor getDebtor() {
        return this.debtor.get();
    }

    protected void setDebtor(AbstractDebtor value) {
        this.debtor.set(value);
    }

    public SalesItemQuantity getSalesItemQuantity() {
        return this.salesItemQuantity.get();
    }

    protected void setSalesItemQuantity(SalesItemQuantity qty) {
        this.salesItemQuantity.set(qty);
    }

    public DebtorGroup getDebtorGroup() {
        return this.getDebtor().getGroup();
    }

    public Date getPurchaseDate() {
        return this.getSalesItemQuantity().getCreationTime();
    }

    public SalesItem getSalesItem() {
        return (SalesItem)this.getSalesItemQuantity().getSalesLineItem();
    }

    public Long getUnitId() {
        return ((SalesItem)this.getSalesItemQuantity().getSalesLineItem()).getComponentList().get(0).getUnit().getID();
    }

    public Price getPriceEx() {
        return this.getPriceInc().subtract(this.getTax());
    }

    public Price getTax() {
        return this.getSalesItem().getTax().divide(this.getSalesItem().getQuantity().getValue());
    }

    public Price getPriceInc() {
        return this.getSalesItem().getPricePerItem();
    }

    public BigDecimal getQuantity() {
        return this.getSalesItemQuantity().getQuantity().getValue();
    }

    public Price getTotalEx() {
        if (this.totalEx == null) {
            this.totalEx = this.getPriceEx().multiply(this.getQuantity());
        }
        return this.totalEx;
    }

    public Price getTotalTax() {
        return this.getTax().multiply(this.getQuantity());
    }

    public Price getTotalInc() {
        return this.getPriceInc().multiply(this.getQuantity());
    }

    public Price getCogs() {
        if (this.cogs == null) {
            this.cogs = Price.ZERO;
            for (SalesComponent comp : this.getSalesItem().getComponentList()) {
                this.cogs = this.cogs.add(comp.getIngredientCostExTax());
            }
            this.cogs = this.cogs.multiply(this.getQuantity());
        }
        return this.cogs;
    }

    public Double getCogsPerc() {
        if (Price.ZERO_DOLLAR.equals(this.getTotalEx())) {
            return 1.0;
        }
        return this.getCogs().divide(this.getTotalEx()).doubleValue();
    }

    public static class Props
    extends PersistentSummaryObject.Props {
        public PropertiedObject.Property<AbstractDebtor> DEBTOR;
        public PropertiedObject.Property<SalesItemQuantity> SALES_ITEM_QUANTITY;
        public PersistentObject.DerivedProperty<SalesItem> SALES_ITEM = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)DebtorSalesItemReport.class), "salesItem");
        public PersistentObject.DerivedProperty<Long> UNIT_ID = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)DebtorSalesItemReport.class), "unitId");
        public PersistentObject.DerivedProperty<DebtorGroup> DEBTOR_GROUP = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)DebtorSalesItemReport.class), "debtorGroup");
        public PersistentObject.DerivedProperty<Date> PURCHASE_DATE = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)DebtorSalesItemReport.class), "purchaseDate");
        public PersistentObject.DerivedProperty<Price> PRICE_EX = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)DebtorSalesItemReport.class), "priceEx");
        public PersistentObject.DerivedProperty<Price> TAX = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)DebtorSalesItemReport.class), "tax");
        public PersistentObject.DerivedProperty<Price> PRICE_INC = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)DebtorSalesItemReport.class), "priceInc");
        public PersistentObject.DerivedProperty<BigDecimal> QUANTITY = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)DebtorSalesItemReport.class), "quantity");
        public PersistentObject.DerivedProperty<Price> TOTAL_EX = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)DebtorSalesItemReport.class), "totalEx");
        public PersistentObject.DerivedProperty<Price> TOTAL_TAX = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)DebtorSalesItemReport.class), "totalTax");
        public PersistentObject.DerivedProperty<Price> TOTAL_INC = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)DebtorSalesItemReport.class), "totalInc");
        public PersistentObject.DerivedProperty<Price> COGS = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)DebtorSalesItemReport.class), "cogs");
        public PersistentObject.DerivedProperty<Number> COGS_PERC = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)DebtorSalesItemReport.class), "cogsPerc");
    }
}

