/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.debtor;

import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.builders.BuilderException;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import ordermate.database.config.ExperimentalFeatureHelper;
import ordermate.database.reports.debtor.DebtorSalesItemReport;
import ordermate.database.searchers.reports.debtor.DebtorSalesItemReportSearcher;
import ordermate.internationalization.Internationalization;
import ordermate.reports.dynamicjasper.ReportBuilder;
import ordermate.reports.dynamicjasper.reportbuilder.AbstractReportProvider;
import ordermate.reports.impl.SearcherDataSourceProvider;

public class DebtorSalesItemReportProvider
extends AbstractReportProvider {
    private DebtorSalesItemReportSearcher searcher;

    public DebtorSalesItemReportProvider(DebtorSalesItemReportSearcher yourSearcher) {
        this.searcher = yourSearcher;
    }

    @Override
    public JRRewindableDataSource getDataSource() {
        return new SearcherDataSourceProvider<DebtorSalesItemReportSearcher>(this.searcher).getDataSource();
    }

    @Override
    protected DynamicReport getReport() throws BuilderException {
        return this.getBuilder().buildJasperReport();
    }

    @Override
    public ReportBuilder getBuilder() throws BuilderException {
        ReportBuilder builder = new ReportBuilder();
        builder.setTitle("Debtor Item Sold Report");
        builder.setSubtitle(this.getFiltersToString());
        builder.addReportColumn(DebtorSalesItemReport.Properties.DEBTOR_GROUP, null);
        builder.addReportColumn(DebtorSalesItemReport.Properties.DEBTOR, null);
        builder.addReportColumn(DebtorSalesItemReport.Properties.PURCHASE_DATE, "dd/MM/yy");
        builder.addReportColumn(DebtorSalesItemReport.Properties.SALES_ITEM, null);
        if (ExperimentalFeatureHelper.isShowItemIds()) {
            builder.addReportColumn(DebtorSalesItemReport.Properties.UNIT_ID, null);
        }
        builder.addReportColumn(DebtorSalesItemReport.Properties.PRICE_EX, Internationalization.getLiteralFor("PRICE_PATTERN"));
        builder.addReportColumn(DebtorSalesItemReport.Properties.TAX, Internationalization.getLiteralFor("PRICE_PATTERN"));
        builder.addReportColumn(DebtorSalesItemReport.Properties.PRICE_INC, Internationalization.getLiteralFor("PRICE_PATTERN"));
        builder.addReportColumn(DebtorSalesItemReport.Properties.QUANTITY, "0");
        builder.addReportColumn(DebtorSalesItemReport.Properties.TOTAL_EX, Internationalization.getLiteralFor("PRICE_PATTERN"));
        builder.addReportColumn(DebtorSalesItemReport.Properties.TOTAL_TAX, Internationalization.getLiteralFor("PRICE_PATTERN"));
        builder.addReportColumn(DebtorSalesItemReport.Properties.TOTAL_INC, Internationalization.getLiteralFor("PRICE_PATTERN"));
        builder.addReportColumn(DebtorSalesItemReport.Properties.COGS, "COGS $", Internationalization.getLiteralFor("PRICE_PATTERN"));
        builder.addReportColumn(DebtorSalesItemReport.Properties.COGS_PERC, "COGS %", "0.0%");
        return builder;
    }

    private String getFiltersToString() {
        StringBuilder sb = new StringBuilder();
        if (this.searcher.getDateFilter().hasSearchValue()) {
            sb.append(this.searcher.getDateFilter().getStart() + " - " + this.searcher.getDateFilter().getEnd());
        }
        this.getHelper().appendSearchFilter(sb, "Trading Day", this.searcher.getTradingDayFilter());
        this.getHelper().appendSearchFilter(sb, "Shift", this.searcher.getShiftConfigFilter());
        this.getHelper().appendSearchFilter(sb, "Sales Location", this.searcher.getSalesLocationFilter());
        return sb.toString();
    }

    @Override
    protected String getAdditionalFooterText() {
        return null;
    }
}

