/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.debtor;

import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.DJGroupLabel;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.BuilderException;
import ar.com.fdvs.dj.domain.builders.ColumnBuilderException;
import ar.com.fdvs.dj.domain.constants.GroupLayout;
import ar.com.fdvs.dj.domain.constants.LabelPosition;
import ar.com.fdvs.dj.domain.entities.DJGroup;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.columns.PropertyColumn;
import au.com.ordermate.util.DateTimeUtils;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import ordermate.database.reports.DebtorTransactionSummaryReport;
import ordermate.database.reports.ReportProviderHelper;
import ordermate.database.searchers.reports.DebtorTransactionSummaryReportSearcher;
import ordermate.internationalization.Internationalization;
import ordermate.reports.dynamicjasper.OrderMateOmorphosReportStyle;
import ordermate.reports.dynamicjasper.ReportBuilder;
import ordermate.reports.dynamicjasper.customexpressions.TimerExpressionBuilder;
import ordermate.reports.dynamicjasper.reportbuilder.AbstractReportProvider;

public class DebtorTransactionSummaryReportProvider
extends AbstractReportProvider {
    private DebtorTransactionSummaryReportSearcher searcher;
    private static final String DATA_PATH = "DTS_REPORT_DATA_PATH";
    private ReportBuilder builder;

    public DebtorTransactionSummaryReportProvider(DebtorTransactionSummaryReportSearcher searchStateSearcher) {
        this.searcher = searchStateSearcher;
    }

    @Override
    public JRRewindableDataSource getDataSource() {
        return new JRBeanCollectionDataSource(this.searcher.search());
    }

    @Override
    protected DynamicReport getReport() throws BuilderException {
        this.initBuilder();
        return this.builder.buildJasperReport();
    }

    private void initBuilder() throws BuilderException, ColumnBuilderException {
        this.builder = new ReportBuilder(new OrderMateOmorphosReportStyle(), ReportBuilder.TemplateFormat.A4Portrait);
        this.getParameters().putAll(this.builder.addBusinessLogoDetailHeaderAndFooterTemplate());
        this.builder.setTitle("Debtor Transaction Summary Report");
        StringBuilder subTitle = new StringBuilder();
        subTitle.append(DateTimeUtils.formatDateForDisplay((Date)this.searcher.getTradingDayDateRangeAdapter().getStart())).append(" - ").append(DateTimeUtils.formatDateForDisplay((Date)this.searcher.getTradingDayDateRangeAdapter().getEnd()));
        this.getHelper().appendSearchFilter(subTitle, "Group", this.searcher.getDebtorGroupSearchFilter());
        this.getHelper().appendSearchFilter(subTitle, "Name", this.searcher.getDebtorNameSearchFilter());
        this.getHelper().appendRangeSearchFilter(subTitle, "Transaction Date", this.searcher.getDebtorTransactionDateRangeSearch(), DateFormat.getDateTimeInstance());
        this.builder.setSubtitle(subTitle.toString());
        this.generateMainReport();
    }

    private DynamicReport generateMainReport() throws BuilderException, ColumnBuilderException {
        ReportBuilder dataSubReportBuilder = this.getBuilder();
        dataSubReportBuilder.getCustomExpressionRegister().put(Integer.class, new TimerExpressionBuilder());
        dataSubReportBuilder.addReportColumn(DebtorTransactionSummaryReport.Properties.DEBTOR_GROUP, null);
        dataSubReportBuilder.addReportColumn(DebtorTransactionSummaryReport.Properties.DEBTOR_NAME, null);
        dataSubReportBuilder.addReportColumn(DebtorTransactionSummaryReport.Properties.BALANCE, Internationalization.getLiteralFor("PRICE_PATTERN"));
        dataSubReportBuilder.addReportColumn(DebtorTransactionSummaryReport.Properties.COST_TOTAL, Internationalization.getLiteralFor("PRICE_PATTERN"));
        dataSubReportBuilder.addReportColumn(DebtorTransactionSummaryReport.Properties.SALES_EX_TAX, Internationalization.getLiteralFor("PRICE_PATTERN"));
        dataSubReportBuilder.addReportColumn(DebtorTransactionSummaryReport.Properties.TAX, Internationalization.getLiteralFor("PRICE_PATTERN"));
        dataSubReportBuilder.addReportColumn(DebtorTransactionSummaryReport.Properties.SALES_INC_TAX, Internationalization.getLiteralFor("PRICE_PATTERN"));
        dataSubReportBuilder.addReportColumn(DebtorTransactionSummaryReport.Properties.PAYMENTS, Internationalization.getLiteralFor("PRICE_PATTERN"));
        ReportBuilder.PropertyCalculation sumBalance = new ReportBuilder.PropertyCalculation(DebtorTransactionSummaryReport.Properties.BALANCE, DJCalculation.SUM);
        ReportBuilder.PropertyCalculation sumCostTotal = new ReportBuilder.PropertyCalculation(DebtorTransactionSummaryReport.Properties.COST_TOTAL, DJCalculation.SUM);
        ReportBuilder.PropertyCalculation sumSalesExTax = new ReportBuilder.PropertyCalculation(DebtorTransactionSummaryReport.Properties.SALES_EX_TAX, DJCalculation.SUM);
        ReportBuilder.PropertyCalculation sumTax = new ReportBuilder.PropertyCalculation(DebtorTransactionSummaryReport.Properties.TAX, DJCalculation.SUM);
        ReportBuilder.PropertyCalculation sumSalesIncTax = new ReportBuilder.PropertyCalculation(DebtorTransactionSummaryReport.Properties.SALES_INC_TAX, DJCalculation.SUM);
        ReportBuilder.PropertyCalculation sumPayments = new ReportBuilder.PropertyCalculation(DebtorTransactionSummaryReport.Properties.PAYMENTS, DJCalculation.SUM);
        DJGroup group = this.builder.addGroupBy(DebtorTransactionSummaryReport.Properties.DEBTOR_GROUP, Arrays.asList(sumBalance, sumCostTotal, sumSalesExTax, sumTax, sumSalesIncTax, sumPayments));
        group.setLayout(GroupLayout.VALUE_IN_HEADER_WITH_HEADERS_AND_COLUMN_NAME);
        group.setReprintHeaderOnEachPage(Boolean.TRUE);
        group.setAllowHeaederSplit(false);
        group.setAllowFooterSplit(false);
        group.setHeaderHeight(Integer.valueOf(25));
        Style groupedColumnStyle = dataSubReportBuilder.getStyles().getGroupedDetailStyle();
        PropertyColumn groupCol = dataSubReportBuilder.getPropertyColumn(DebtorTransactionSummaryReport.Properties.DEBTOR_GROUP);
        groupCol.setHeaderStyle(groupedColumnStyle);
        groupCol.setStyle(groupedColumnStyle);
        this.hideColumnName(groupCol);
        DJGroupLabel footerLabel = new DJGroupLabel("Sub Total: ", this.builder.getStyles().getFooterVariableStyle(), LabelPosition.LEFT);
        group.setFooterLabel(footerLabel);
        dataSubReportBuilder.getReportBuilder().setAllowDetailSplit(false);
        dataSubReportBuilder.getReportBuilder().addGlobalFooterVariable((AbstractColumn)dataSubReportBuilder.getPropertyColumn(DebtorTransactionSummaryReport.Properties.BALANCE), DJCalculation.SUM, null);
        dataSubReportBuilder.getReportBuilder().addGlobalFooterVariable((AbstractColumn)dataSubReportBuilder.getPropertyColumn(DebtorTransactionSummaryReport.Properties.COST_TOTAL), DJCalculation.SUM, null);
        dataSubReportBuilder.getReportBuilder().addGlobalFooterVariable((AbstractColumn)dataSubReportBuilder.getPropertyColumn(DebtorTransactionSummaryReport.Properties.SALES_EX_TAX), DJCalculation.SUM, null);
        dataSubReportBuilder.getReportBuilder().addGlobalFooterVariable((AbstractColumn)dataSubReportBuilder.getPropertyColumn(DebtorTransactionSummaryReport.Properties.TAX), DJCalculation.SUM, null);
        dataSubReportBuilder.getReportBuilder().addGlobalFooterVariable((AbstractColumn)dataSubReportBuilder.getPropertyColumn(DebtorTransactionSummaryReport.Properties.SALES_INC_TAX), DJCalculation.SUM, null);
        dataSubReportBuilder.getReportBuilder().addGlobalFooterVariable((AbstractColumn)dataSubReportBuilder.getPropertyColumn(DebtorTransactionSummaryReport.Properties.PAYMENTS), DJCalculation.SUM, null);
        dataSubReportBuilder.setUseGrandTotal(true);
        return dataSubReportBuilder.buildJasperReport();
    }

    @Override
    public ReportBuilder getBuilder() throws BuilderException {
        if (this.builder == null) {
            this.initBuilder();
        }
        return this.builder;
    }

    @Override
    protected String getAdditionalFooterText() {
        return "Sales in this report are being filtered based on " + ReportProviderHelper.describeQueryLink(this.searcher.getSQLString());
    }
}

