/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.driver;

import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentSummaryObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.Price;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import ordermate.database.sales.Customer;
import ordermate.database.sales.Delivery;
import ordermate.database.sales.PhoneAccount;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.users.User;

public class DriverManifestReport
extends PersistentSummaryObject {
    public static final Props Properties = new Props();
    private Reference<User> driver;
    private Reference<Customer> customer;
    private Reference<PhoneAccount> account;
    private Reference<Delivery> delivery;
    private Date dueDateTime;

    public DriverManifestReport() {
        this.driver = this.createReference(DriverManifestReport.Properties.DRIVER);
        this.customer = this.createReference(DriverManifestReport.Properties.CUSTOMER);
        this.account = this.createReference(DriverManifestReport.Properties.ACCOUNT);
        this.delivery = this.createReference(DriverManifestReport.Properties.DELIVERY);
    }

    public void setDriver(User newDriver) {
        this.driver.set(newDriver);
    }

    public User getDriver() {
        return this.driver.get();
    }

    public void setCustomer(Customer newCustomer) {
        this.customer.set(newCustomer);
    }

    public Customer getCustomer() {
        return this.customer.get();
    }

    public void setAccount(PhoneAccount phoneAccount) {
        this.account.set(phoneAccount);
    }

    public PhoneAccount getAccount() {
        return this.account.get();
    }

    public void setDelivery(Delivery newDelivery) {
        this.delivery.set(newDelivery);
    }

    public Delivery getDelivery() {
        return this.delivery.get();
    }

    public String getDriverName() {
        return this.getDriver().getName();
    }

    public String getCustomerName() {
        return this.getCustomer().getName();
    }

    public String getCustomerAddress() {
        return this.getCustomer().getAddressNoSuburbPostCode();
    }

    public Long getReceiptNumber() {
        return this.getAccount().getID();
    }

    public Price getAccountTotal() {
        return this.getAccount().getSavedTotal();
    }

    public Long getDeliveryID() {
        return this.getDelivery().getID();
    }

    public Date getDeliveryCreated() {
        return this.getDelivery().getTimeCreated();
    }

    public Date getDeliveryCompleted() {
        return this.getDelivery().getTimeCompleted();
    }

    public BigDecimal getItemsQuantityTotal() {
        SalesQuantity salesItems = SalesQuantity.ZERO;
        List<SalesLineItem> items = this.getAccount().getItems();
        for (SalesLineItem item : items) {
            salesItems = salesItems.add(item.getQuantity());
        }
        return salesItems.getValue();
    }

    public String getCustomerSuburb() {
        return this.getCustomer().getSuburb();
    }

    public String getCustomerPostcode() {
        return this.getCustomer().getPostcode();
    }

    public void setDueDateTime(Date dateTime) {
        this.dueDateTime = dateTime;
    }

    public Date getDueDateTime() {
        return this.dueDateTime;
    }

    public String getTimeDue() {
        return DateTimeUtils.getDateTimeFormat().format(this.dueDateTime);
    }

    public static class Props
    extends PersistentSummaryObject.Props {
        public PropertiedObject.Property<User> DRIVER;
        public PropertiedObject.Property<Customer> CUSTOMER;
        public PropertiedObject.Property<PhoneAccount> ACCOUNT;
        public PropertiedObject.Property<Delivery> DELIVERY;
        public PropertiedObject.Property<Date> DUE_DATE_TIME;
        public PersistentObject.DerivedProperty<String> DRIVER_NAME = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)DriverManifestReport.class), "driverName");
        public PersistentObject.DerivedProperty<String> CUSTOMER_NAME = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)DriverManifestReport.class), "customerName");
        public PersistentObject.DerivedProperty<String> CUSTOMER_ADDRESS = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)DriverManifestReport.class), "customerAddress");
        public PersistentObject.DerivedProperty<String> CUSTOMER_SUBURB = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)DriverManifestReport.class), "customerSuburb");
        public PersistentObject.DerivedProperty<String> CUSTOMER_POSTCODE = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)DriverManifestReport.class), "customerPostcode");
        public PersistentObject.DerivedProperty<Integer> RECEIPT_NUMBER = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)DriverManifestReport.class), "receiptNumber");
        public PersistentObject.DerivedProperty<Double> ACCOUNT_TOTAL = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)DriverManifestReport.class), "accountTotal");
        public PersistentObject.DerivedProperty<Integer> DELIVERY_ID = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)DriverManifestReport.class), "deliveryID");
        public PersistentObject.DerivedProperty<Date> DELIVERY_CREATED = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)DriverManifestReport.class), "deliveryCreated");
        public PersistentObject.DerivedProperty<Date> DELIVERY_COMPLETED = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)DriverManifestReport.class), "deliveryCompleted");
        public PersistentObject.DerivedProperty<Integer> ITEMS_QUANTITY_TOTAL = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)DriverManifestReport.class), "itemsQuantityTotal");
        public PersistentObject.DerivedProperty<String> TIME_DUE = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)DriverManifestReport.class), "timeDue");
    }
}

