/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.driver;

import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.BuilderException;
import ar.com.fdvs.dj.domain.constants.Page;
import ar.com.fdvs.dj.domain.entities.DJGroup;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import au.com.ordermate.util.DateTimeUtils;
import java.awt.Color;
import java.util.Date;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.config.custom.JasperReportHelper;
import ordermate.database.reports.driver.DriverManifestReport;
import ordermate.database.searchers.reports.TradingDayFilteredReportSearcher;
import ordermate.database.searchers.reports.driver.DriverManifestReportSearcher;
import ordermate.internationalization.Internationalization;
import ordermate.reports.dynamicjasper.OrderMateOmorphosReportStyle;
import ordermate.reports.dynamicjasper.ReportBuilder;
import ordermate.reports.dynamicjasper.customexpressions.DateExpressionBuilder;
import ordermate.reports.dynamicjasper.reportbuilder.AbstractReportProvider;
import ordermate.reports.impl.SearcherDataSourceProvider;

public class DriverManifestReportProvider
extends AbstractReportProvider {
    private SearcherDataSourceProvider searcherDataSourceProvider;

    public DriverManifestReportProvider(DriverManifestReportSearcher searcher) {
        this.searcherDataSourceProvider = new SearcherDataSourceProvider<DriverManifestReportSearcher>(searcher);
    }

    @Override
    public JRRewindableDataSource getDataSource() {
        return this.searcherDataSourceProvider.getDataSource();
    }

    @Override
    protected DynamicReport getReport() throws BuilderException {
        return this.getBuilder().buildJasperReport();
    }

    @Override
    public ReportBuilder getBuilder() throws BuilderException {
        ReportBuilder builder = new ReportBuilder(new OrderMateOmorphosReportStyle(), ReportBuilder.TemplateFormat.A4Landscape);
        this.getParameters().putAll(builder.addBusinessLogoDetailHeaderAndFooterTemplate());
        builder.getReportBuilder().setPageSizeAndOrientation(Page.Page_A4_Landscape());
        builder.setTitle("Driver Manifest Report");
        DriverManifestReportSearcher searcher = (DriverManifestReportSearcher)this.searcherDataSourceProvider.getSearch();
        TradingDay day = (TradingDay)searcher.getTradingDayFilter().getSearchValue();
        if (day != null) {
            StringBuilder subTitle = new StringBuilder("");
            subTitle.append(day.getFullLabel());
            if (day.getCloseTime() != null) {
                subTitle.append(" ");
                subTitle.append(TradingDayFilteredReportSearcher.DisplayHelper.formatTradingDayCloseTime(day.getCloseTime()));
            }
            this.getHelper().appendSearchFilter(subTitle, "Driver", searcher.getDriverFilter());
            builder.setSubtitle(subTitle.toString());
        }
        builder.getCustomExpressionRegister().put(Date.class, new DateExpressionBuilder(DateTimeUtils.getSimpleTimeFormat()));
        builder.addReportColumn(DriverManifestReport.Properties.DRIVER_NAME, "Driver", null);
        builder.addReportColumn(DriverManifestReport.Properties.DELIVERY_ID, "Delivery ID", null);
        builder.addReportColumn(DriverManifestReport.Properties.DELIVERY_CREATED, "Delivery Created", "h:m a");
        builder.addReportColumn(DriverManifestReport.Properties.DELIVERY_COMPLETED, "Delivery Completed", "h:m a");
        builder.addReportColumn(DriverManifestReport.Properties.TIME_DUE, "Time Due");
        builder.addReportColumn(DriverManifestReport.Properties.CUSTOMER_NAME, "Customer", null);
        builder.addReportColumn(DriverManifestReport.Properties.CUSTOMER_ADDRESS, "Address", null);
        builder.addReportColumn(DriverManifestReport.Properties.CUSTOMER_SUBURB, "Suburb", null);
        builder.addReportColumn(DriverManifestReport.Properties.CUSTOMER_POSTCODE, "Postcode", null);
        builder.addReportColumn(DriverManifestReport.Properties.RECEIPT_NUMBER, "Receipt Number", null);
        builder.addReportColumn(DriverManifestReport.Properties.ITEMS_QUANTITY_TOTAL, "Items Total", null);
        builder.addReportColumn(DriverManifestReport.Properties.ACCOUNT_TOTAL, "Total Cost", Internationalization.getLiteralFor("PRICE_PATTERN"));
        Style styleRightAlign = JasperReportHelper.rightAlignStyle(builder.getStyles().getColumnDetailStyle());
        Style styleHeaderRightAlign = JasperReportHelper.rightAlignStyle(builder.getStyles().getColumnHeaderStyle());
        builder.getPropertyColumn(DriverManifestReport.Properties.ACCOUNT_TOTAL).setStyle(styleRightAlign);
        builder.getPropertyColumn(DriverManifestReport.Properties.ACCOUNT_TOTAL).setHeaderStyle(styleHeaderRightAlign);
        Style totalLineStyleRightAlign = JasperReportHelper.rightAlignStyle(this.getTotalLineStyle());
        Style totalLineStyle = this.getTotalLineStyle();
        DJGroup group = new DJGroup();
        group.setColumnToGroupBy(builder.getPropertyColumn(DriverManifestReport.Properties.DRIVER_NAME));
        group.setReprintHeaderOnEachPage(Boolean.TRUE);
        group.setAllowHeaederSplit(false);
        group.setAllowFooterSplit(false);
        builder.getReportBuilder().addGroup(group);
        builder.getReportBuilder().addGlobalFooterVariable((AbstractColumn)builder.getPropertyColumn(DriverManifestReport.Properties.DELIVERY_ID), DJCalculation.COUNT, totalLineStyle);
        builder.getReportBuilder().addGlobalFooterVariable((AbstractColumn)builder.getPropertyColumn(DriverManifestReport.Properties.ACCOUNT_TOTAL), DJCalculation.SUM, totalLineStyleRightAlign);
        builder.getReportBuilder().setGrandTotalLegend("TOTALS: ");
        return builder;
    }

    @Override
    protected String getAdditionalFooterText() {
        return null;
    }

    private Style getTotalLineStyle() {
        Style style = new Style();
        style.getFont().setBold(true);
        style.setTextColor(Color.BLACK);
        return style;
    }
}

