/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.events;

import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.builders.BuilderException;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import ordermate.database.misc.EventLogRecord;
import ordermate.database.searchers.reports.EventSearcher;
import ordermate.reports.dynamicjasper.ReportBuilder;
import ordermate.reports.dynamicjasper.reportbuilder.AbstractReportProvider;
import ordermate.reports.impl.SearcherDataSourceProvider;

public class EventReportProvider
extends AbstractReportProvider {
    private EventSearcher searcher;

    public EventReportProvider(EventSearcher yourSearcher) {
        this.searcher = yourSearcher;
    }

    @Override
    public JRRewindableDataSource getDataSource() {
        return new SearcherDataSourceProvider<EventSearcher>(this.searcher).getDataSource();
    }

    @Override
    protected DynamicReport getReport() throws BuilderException {
        return this.getBuilder().buildJasperReport();
    }

    @Override
    public ReportBuilder getBuilder() throws BuilderException {
        ReportBuilder builder = new ReportBuilder();
        builder.setTitle("Transaction Journal");
        StringBuilder SB = new StringBuilder();
        this.getHelper().appendDatedSubtitle(SB, this.searcher.getDateRangeFilter(), this.searcher.getTimeRangeFilter());
        this.getHelper().appendSearchFilter(SB, "Terminals", this.searcher.getTerminalFilter());
        this.getHelper().appendSearchFilter(SB, "Shifts", this.searcher.getShiftFilter());
        this.getHelper().appendSearchFilter(SB, "Users", this.searcher.getUserFilter());
        this.getHelper().appendSearchFilter(SB, "Event Types", this.searcher.getEventTypeFilter());
        String text = (String)this.searcher.getEventLogTextFilter().getSearchValue();
        this.getHelper().appendSubTitleAndValue(SB, "Text Like", text);
        builder.setSubtitle(SB.toString());
        builder.addReportColumn(EventLogRecord.Properties.EVENT_DATE, "dd/MM/yy");
        builder.addReportColumn(EventLogRecord.Properties.EVENT_TIME, "hh:mm:ss a");
        builder.addReportColumn(EventLogRecord.Properties.TYPE, null);
        builder.addReportColumn(EventLogRecord.Properties.USER, null);
        builder.addReportColumn(EventLogRecord.Properties.TERMINAL, null);
        builder.addReportColumn(EventLogRecord.Properties.MESSAGE, null);
        builder.addReportColumn(EventLogRecord.Properties.SHIFT_LABEL, null);
        return builder;
    }

    @Override
    protected String getAdditionalFooterText() {
        return null;
    }
}

