/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.feedback;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.RangeQuerySearchFilter;
import au.com.ordermate.search.abstracts.SingleValueSearchFilter;
import java.util.Date;
import ordermate.database.feedback.FeedbackQuestion;
import ordermate.database.feedback.FeedbackResponse;
import ordermate.database.reports.feedback.FeedbackReport;
import ordermate.database.sales.itemfilter.TimeSearchFilter;

public class FeedbackReportSearcher
extends PropertySearcher<FeedbackReport> {
    IRangedQuerySearchFilter<Date> dateFilter;
    private final TimeSearchFilter timeFilter;
    private final SingleValueSearchFilter<FeedbackQuestion> questionFilter;

    public FeedbackReportSearcher() {
        super(FeedbackReport.class);
        this.dateFilter = new RangeQuerySearchFilter<Date>(FeedbackResponse.Properties.RESPONSE_DATE, SQLDateType.TIMESTAMP);
        this.timeFilter = new TimeSearchFilter(FeedbackResponse.Properties.RESPONSE_DATE);
        this.questionFilter = new ObjectSearchFilter<FeedbackQuestion>(FeedbackResponse.Properties.QUESTION);
        this.addSearchFilter(this.dateFilter);
        this.addSearchFilter(this.timeFilter);
        this.addSearchFilter(this.questionFilter);
    }

    @Override
    protected ObjectQuery getBaseQuery() {
        return Query.select(FeedbackResponse.Properties.QUESTION).select(FeedbackResponse.Properties.ANSWER).count(FeedbackResponse.class, "count").groupBy(FeedbackResponse.Properties.QUESTION).groupBy(FeedbackResponse.Properties.ANSWER);
    }

    public IRangedQuerySearchFilter<Date> getDateFilter() {
        return this.dateFilter;
    }

    public TimeSearchFilter getTimeFilter() {
        return this.timeFilter;
    }

    public SingleValueSearchFilter<FeedbackQuestion> getQuestionFilter() {
        return this.questionFilter;
    }
}

