/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.finance;

import ar.com.fdvs.dj.domain.ColumnProperty;
import ar.com.fdvs.dj.domain.CustomExpression;
import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.DJValueFormatter;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.BuilderException;
import ar.com.fdvs.dj.domain.constants.Font;
import ar.com.fdvs.dj.domain.constants.HorizontalAlign;
import ar.com.fdvs.dj.domain.constants.VerticalAlign;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.columns.ExpressionColumn;
import ar.com.fdvs.dj.domain.entities.columns.PropertyColumn;
import au.com.ordermate.util.Price;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.Map;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import ordermate.OrderMate;
import ordermate.database.finance.Denomination;
import ordermate.database.reports.finance.CashDrawerDenominationReport;
import ordermate.database.reports.finance.DenominationReport;
import ordermate.database.reports.finance.DenominationReportCompiler;
import ordermate.reports.dynamicjasper.ReportBuilder;
import ordermate.reports.dynamicjasper.customexpressions.ListResolvingExpression;
import ordermate.reports.dynamicjasper.reportbuilder.AbstractReportProvider;

public class CashDrawerDenominationAggregateReportProvider
extends AbstractReportProvider {
    private final ReportBuilder builder;
    private DenominationReportCompiler compiler;

    public CashDrawerDenominationAggregateReportProvider(DenominationReportCompiler compiler) {
        this.compiler = compiler;
        this.builder = new ReportBuilder(ReportBuilder.TemplateFormat.A4Landscape);
        try {
            this.initBuilder();
        }
        catch (BuilderException e) {
            OrderMate.LOG.error("Cannot build CashDrawerDenominationAggregatedReport", (Throwable)e);
        }
    }

    public DenominationReportCompiler getCompiler() {
        return this.compiler;
    }

    private final void initBuilder() throws BuilderException {
        this.getParameters().putAll(this.builder.addBusinessLogoDetailHeaderAndFooterTemplate());
        Denomination[] denoms = this.compiler.getDenominations();
        this.builder.addInvisibleField(CashDrawerDenominationReport.Properties.REPORT);
        this.builder.addReportColumn(CashDrawerDenominationReport.Properties.CASH_DRAWER_NAME, "CashDrawer", null);
        this.builder.setTitle("Denomination Report");
        Style countStyle = new Style();
        countStyle.setTextColor(Color.black);
        countStyle.setFont(Font.ARIAL_SMALL);
        countStyle.setHorizontalAlign(HorizontalAlign.RIGHT);
        countStyle.setVerticalAlign(VerticalAlign.TOP);
        int index = 0;
        for (final Denomination denom : denoms) {
            String denomName = this.getColumnName(denom);
            ExpressionColumn column = new ExpressionColumn();
            column.setExpression((CustomExpression)new ListResolvingExpression(index, CashDrawerDenominationReport.Properties.REPORTS, DenominationReport.Properties.COUNT));
            column.setTitle(denomName);
            column.setColumnProperty(new ColumnProperty("count", DenominationReport.class));
            column.setWidth(Integer.valueOf(35));
            column.setPattern("0");
            column.setStyle(countStyle);
            this.builder.getReportBuilder().addColumn((AbstractColumn)column);
            DJValueFormatter formatter = new DJValueFormatter(){

                public Object evaluate(Object arg0, Map arg1, Map arg2, Map arg3) {
                    double value = denom.getValue();
                    int count = ((Number)arg0).intValue();
                    if (value < 1.0) {
                        return count + "\r\n (" + new Price(value * (double)count, 0.01) + ")";
                    }
                    return count + "\r\n ($" + (int)(value * (double)count) + ")";
                }

                public String getClassName() {
                    return String.class.getName();
                }
            };
            this.builder.getReportBuilder().addGlobalFooterVariable((AbstractColumn)column, DJCalculation.SUM, countStyle, formatter);
            ++index;
        }
        this.builder.addReportColumn(CashDrawerDenominationReport.Properties.VALUE, "Total Value", "$0.00");
        PropertyColumn column = this.builder.getPropertyColumn(CashDrawerDenominationReport.Properties.VALUE);
        column.setStyle(countStyle);
        this.builder.addFooterCalculation(new ReportBuilder.PropertyCalculation(CashDrawerDenominationReport.Properties.VALUE, DJCalculation.SUM));
        this.builder.setUseGrandTotal(true);
        this.builder.getReportBuilder().setGlobalFooterVariableHeight(40);
        this.builder.getReportBuilder().setGrandTotalLegend("Total");
    }

    private String getColumnName(Denomination denom) {
        if (denom.getValue() < 1.0) {
            return DecimalFormat.getIntegerInstance().format(denom.getValue() * 100.0) + "c";
        }
        return "\\$" + DecimalFormat.getIntegerInstance().format(denom.getValue());
    }

    @Override
    public JRRewindableDataSource getDataSource() {
        return new JRBeanCollectionDataSource(this.compiler.aggregateReports());
    }

    @Override
    protected DynamicReport getReport() throws BuilderException {
        StringBuilder SB = new StringBuilder();
        this.getHelper().appendSearchFilter(SB, "Trading Day", this.compiler.getSearcher().getTradingDayFilter());
        this.getHelper().appendSearchFilter(SB, "Shift", this.compiler.getSearcher().getShiftFilter());
        this.builder.setSubtitle(SB.toString());
        return this.builder.buildJasperReport();
    }

    @Override
    public ReportBuilder getBuilder() throws BuilderException {
        return this.builder;
    }

    @Override
    protected String getAdditionalFooterText() {
        return null;
    }
}

