/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.finance;

import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import ordermate.database.finance.Denomination;
import ordermate.database.reports.finance.DenominationReport;

public class CashDrawerDenominationReport
implements PropertiedObject {
    public static final Props Properties = new Props();
    private List<DenominationReport> reports;

    public CashDrawerDenominationReport(DenominationReport prototypeReport, Denomination[] doms) {
        this.reports = new ArrayList<DenominationReport>(doms.length);
        for (Denomination dom : doms) {
            this.reports.add(new DenominationReport(prototypeReport.getCashDrawer(), dom, 0, prototypeReport.getName(), prototypeReport.getCashDrawerName()));
        }
    }

    public CashDrawerDenominationReport getReport() {
        return this;
    }

    public String getCashDrawerName() {
        return this.reports.get(0).getCashDrawerName();
    }

    public String getName() {
        return this.reports.get(0).getName();
    }

    public List<DenominationReport> getReports() {
        return this.reports;
    }

    public int getCount() {
        int count = 0;
        for (DenominationReport report : this.reports) {
            count += report.getCount();
        }
        return count;
    }

    public BigDecimal getValue() {
        double value = 0.0;
        for (DenominationReport report : this.reports) {
            value += report.getValue().doubleValue();
        }
        return new BigDecimal(value);
    }

    public void addReport(DenominationReport report) {
        for (DenominationReport nextReport : this.reports) {
            if (!nextReport.getDenomination().equals(report.getDenomination())) continue;
            nextReport.add(report);
            break;
        }
    }

    @Override
    public Props getProperties() {
        return Properties;
    }

    @Override
    public <T> T getPropertyValue(PropertiedObject.Property<T> prop) {
        return PropertiedObject.PropsHelper.getPropertyValue(this, prop);
    }

    public static class Props
    extends PropertiedObject.Props {
        public PersistentObject.DerivedProperty<CashDrawerDenominationReport> REPORT = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)CashDrawerDenominationReport.class), "report");
        public PersistentObject.DerivedProperty<String> CASH_DRAWER_NAME = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)CashDrawerDenominationReport.class), "cashDrawerName");
        public PersistentObject.DerivedProperty<String> NAME = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)CashDrawerDenominationReport.class), "name");
        public PersistentObject.DerivedProperty<DenominationReport> REPORTS = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)CashDrawerDenominationReport.class), "reports");
        public PersistentObject.DerivedProperty COUNT = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)CashDrawerDenominationReport.class), "count");
        public PersistentObject.DerivedProperty VALUE = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)CashDrawerDenominationReport.class), "value");
    }
}

