/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.finance;

import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentSummaryObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import java.math.BigDecimal;
import ordermate.database.finance.Denomination;
import ordermate.database.hardware.physical.CashDrawer;

public class DenominationReport
extends PersistentSummaryObject {
    public static final Props Properties = new Props();
    private Reference<CashDrawer> cashDrawer;
    private Reference<Denomination> denomination;
    private int count;
    private String name;
    private String cashDrawerName;

    @Deprecated
    public DenominationReport() {
        this.cashDrawer = this.createReference(DenominationReport.Properties.CASH_DRAWER);
        this.denomination = this.createReference(DenominationReport.Properties.DENOMINATION);
    }

    public DenominationReport(CashDrawer cd, Denomination den, int unitCount, String theName, String theCashDrawerName) {
        this.cashDrawer = this.createReference(DenominationReport.Properties.CASH_DRAWER);
        this.denomination = this.createReference(DenominationReport.Properties.DENOMINATION);
        this.setCashDrawer(cd);
        this.setDenomination(den);
        this.setCount(unitCount);
        this.setName(theName);
        this.setCashDrawerName(theCashDrawerName);
    }

    public String getCashDrawerName() {
        if (this.cashDrawerName == null) {
            this.cashDrawerName = this.getCashDrawer() == null ? "" : this.getCashDrawer().getLabel();
        }
        return this.cashDrawerName;
    }

    public void setCashDrawerName(String value) {
        this.cashDrawerName = value;
    }

    public CashDrawer getCashDrawer() {
        return this.cashDrawer.get();
    }

    public void setCashDrawer(CashDrawer value) {
        this.cashDrawer.set(value);
    }

    public Denomination getDenomination() {
        return this.denomination.get();
    }

    public void setDenomination(Denomination den) {
        this.denomination.set(den);
    }

    public String getDenominationName() {
        return this.denomination.get().getLabel();
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int value) {
        this.count = value;
    }

    public BigDecimal getValue() {
        return new BigDecimal((double)this.count * this.getDenomination().getValue());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public void add(DenominationReport report) {
        this.count += report.getCount();
    }

    public static class Props
    extends PersistentSummaryObject.Props {
        public PropertiedObject.Property<Denomination> DENOMINATION;
        public PropertiedObject.Property<String> NAME;
        public PropertiedObject.Property<Integer> COUNT;
        public PropertiedObject.Property<CashDrawer> CASH_DRAWER;
        public PersistentObject.DerivedProperty<String> CASH_DRAWER_NAME = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)DenominationReport.class), "cashDrawerName");
        public PersistentObject.DerivedProperty<BigDecimal> VALUE = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)DenominationReport.class), "value");
        public PersistentObject.DerivedProperty<String> DENOMINATION_NAME = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)DenominationReport.class), "denominationName");
    }
}

