/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.finance;

import au.com.ordermate.glazedlists.PropertyComparator;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.annotation.FilterConfig;
import au.com.ordermate.oquery.search.filter.implementation.SingleValueQuerySearchFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import ordermate.database.finance.Denomination;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.reports.finance.CashDrawerDenominationReport;
import ordermate.database.reports.finance.DenominationReport;
import ordermate.database.reports.finance.RecByDenominationSearcher;
import ordermate.database.reports.finance.SkimsByDenominationSearcher;

public class DenominationReportCompiler {
    private RecByDenominationSearcher recSearcher = new RecByDenominationSearcher();
    private SkimsByDenominationSearcher skimSearcher = new SkimsByDenominationSearcher();
    private Denomination[] denominations;

    public DenominationReportCompiler() {
        Denomination[] normalDoms = Denomination.getDenominations();
        this.denominations = new Denomination[normalDoms.length];
        for (int i = 0; i < normalDoms.length; ++i) {
            this.denominations[normalDoms.length - i - 1] = normalDoms[i];
        }
    }

    public RecByDenominationSearcher getSearcher() {
        return this.recSearcher;
    }

    public List<CashDrawerDenominationReport> aggregateReports() {
        this.matchFilters();
        List<DenominationReport> recReports = this.recSearcher.search();
        List<DenominationReport> skimReports = this.skimSearcher.search();
        List<CashDrawerDenominationReport> cdReports = this.aggregate(recReports, skimReports);
        Collections.sort(cdReports, new PropertyComparator(CashDrawerDenominationReport.Properties.CASH_DRAWER_NAME));
        return cdReports;
    }

    private void matchFilters() {
        this.skimSearcher.getShiftFilter().setSearchValue(this.recSearcher.getShiftFilter().getSearchValue());
        this.skimSearcher.getTradingDayFilter().setSearchValue(this.recSearcher.getTradingDayFilter().getSearchValue());
    }

    private List<CashDrawerDenominationReport> aggregate(List<DenominationReport> recReports, List<DenominationReport> skimReports) {
        ArrayList<CashDrawerDenominationReport> reports = new ArrayList<CashDrawerDenominationReport>();
        HashMap<CashDrawer, CashDrawerDenominationReport> cdMap = new HashMap<CashDrawer, CashDrawerDenominationReport>();
        for (DenominationReport report : recReports) {
            if (!cdMap.containsKey(report.getCashDrawer())) {
                cdMap.put(report.getCashDrawer(), new CashDrawerDenominationReport(report, this.denominations));
            }
            ((CashDrawerDenominationReport)cdMap.get(report.getCashDrawer())).addReport(report);
        }
        for (DenominationReport report : skimReports) {
            if (!cdMap.containsKey(report.getCashDrawer())) {
                cdMap.put(report.getCashDrawer(), new CashDrawerDenominationReport(report, this.denominations));
            }
            ((CashDrawerDenominationReport)cdMap.get(report.getCashDrawer())).addReport(report);
        }
        reports.addAll(cdMap.values());
        return reports;
    }

    public Denomination[] getDenominations() {
        return this.denominations;
    }

    @FilterConfig(name="Date", defaultValue="DateRange", dateType=SQLDateType.DATE, dataType=Date.class, plural=FilterConfig.Plural.Single, nullAllowed=false, priority=true, sequence=1)
    public SingleValueQuerySearchFilter<Date> getDateRangeFilter() {
        return this.getSearcher().getFixedDateFilter();
    }
}

