/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.finance;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.reports.MakesReport;
import au.com.ordermate.reports.ReportConfigureColumnMetaData;
import java.util.List;
import ordermate.database.finance.reconciliation.ShiftReconciliation;
import ordermate.database.reports.finance.CashDrawerDenominationAggregateReportProvider;
import ordermate.database.reports.finance.DenominationReportCompiler;
import ordermate.database.reports.maker.ConfigurableReportMaker;

@MakesReport(value="Denominations", description="Cash takings recorded using the reconciliation feature broken down by denomination, usually used for banking", category="Audit", columnMetaData={@ReportConfigureColumnMetaData(name="Cashdrawer", locked=true)}, permission="Skims")
public class DenominationReportMaker
extends ConfigurableReportMaker<DenominationReportCompiler, CashDrawerDenominationAggregateReportProvider> {
    @Override
    protected DenominationReportCompiler createSearchFilter() {
        DenominationReportCompiler compiler = new DenominationReportCompiler();
        List<ShiftReconciliation> recs = PersistenceManager.getObjectList(ShiftReconciliation.class, Query.select(ShiftReconciliation.class).equals(ShiftReconciliation.Properties.COMPLETED, Boolean.TRUE).orderBy(ShiftReconciliation.Properties.ID, true).toString());
        if (!recs.isEmpty()) {
            compiler.getSearcher().getShiftFilter().setSearchValue(recs.get(0).getShift());
        }
        return compiler;
    }

    @Override
    protected CashDrawerDenominationAggregateReportProvider createReportProvider(DenominationReportCompiler yourSearcher) {
        return new CashDrawerDenominationAggregateReportProvider(yourSearcher);
    }
}

