/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.finance;

import au.com.ordermate.persistence.PersistentSummaryObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.util.Price;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.misc.DayPart;
import ordermate.database.misc.TradingDay;

public class FinanceUnitTotalsReport
extends PersistentSummaryObject {
    public static final Props Properties = new Props();
    private Reference<TradingDay> tradingDay;
    private Reference<DayPart> dayPart;
    private Reference<FinanceUnit> unit;
    private Reference<CashDrawer> cashDrawer;
    private Price total;

    public FinanceUnitTotalsReport() {
        this.tradingDay = this.createReference(FinanceUnitTotalsReport.Properties.TRADING_DAY);
        this.dayPart = this.createReference(FinanceUnitTotalsReport.Properties.DAY_PART);
        this.unit = this.createReference(FinanceUnitTotalsReport.Properties.UNIT);
        this.cashDrawer = this.createReference(FinanceUnitTotalsReport.Properties.CASH_DRAWER);
        this.total = Price.ZERO_NO_ROUND;
    }

    public FinanceUnitTotalsReport(TradingDay day, DayPart dayPart, Price totalValue, FinanceUnit unitValue) {
        this.tradingDay = this.createReference(FinanceUnitTotalsReport.Properties.TRADING_DAY);
        this.dayPart = this.createReference(FinanceUnitTotalsReport.Properties.DAY_PART);
        this.unit = this.createReference(FinanceUnitTotalsReport.Properties.UNIT);
        this.cashDrawer = this.createReference(FinanceUnitTotalsReport.Properties.CASH_DRAWER);
        this.setTradingDay(day);
        this.setDayPart(dayPart);
        this.setTotal(totalValue);
        this.setUnit(unitValue);
    }

    public Price getTotal() {
        return this.total;
    }

    public void setTotal(Price value) {
        this.total = value;
    }

    public FinanceUnit getUnit() {
        return this.unit.get();
    }

    protected void setUnit(FinanceUnit value) {
        this.unit.set(value);
    }

    public TradingDay getTradingDay() {
        return this.tradingDay.get();
    }

    protected void setTradingDay(TradingDay value) {
        this.tradingDay.set(value);
    }

    public DayPart getDayPart() {
        return this.dayPart.get();
    }

    protected void setDayPart(DayPart value) {
        this.dayPart.set(value);
    }

    public CashDrawer getCashDrawer() {
        return this.cashDrawer.get();
    }

    protected void setCashDrawer(CashDrawer value) {
        this.cashDrawer.set(value);
    }

    public static class Props
    extends PersistentSummaryObject.Props {
        public PropertiedObject.Property<TradingDay> TRADING_DAY;
        public PropertiedObject.Property<DayPart> DAY_PART;
        public PropertiedObject.Property<FinanceUnit> UNIT;
        public PropertiedObject.Property<Price> TOTAL;
        public PropertiedObject.Property<CashDrawer> CASH_DRAWER;
    }
}

