/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.finance;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.filter.implementation.ObjectJoinSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.SingleValueQuerySearchFilter;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PropertiedObject;
import java.util.Date;
import ordermate.database.finance.Shift;
import ordermate.database.finance.reconciliation.CashdrawerReconciliation;
import ordermate.database.finance.reconciliation.ShiftReconciliation;
import ordermate.database.finance.reconciliation.entries.ActualCashEntry;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.finance.DenominationReport;

public class RecByDenominationSearcher
extends PropertySearcher<DenominationReport> {
    private ObjectJoinSearchFilter<Shift> shiftFilter;
    private ObjectJoinSearchFilter<TradingDay> tradingDayFilter;
    private final ObjectSearchFilter<Date> dateFilter;

    public RecByDenominationSearcher() {
        super(DenominationReport.class);
        this.shiftFilter = new ObjectJoinSearchFilter<Shift>(new PropertiedObject.Property[]{CashdrawerReconciliation.Properties.PARENT}, new ObjectSearchFilter<Shift>(ShiftReconciliation.Properties.SHIFT));
        this.tradingDayFilter = new ObjectJoinSearchFilter<TradingDay>(new PropertiedObject.Property[]{CashdrawerReconciliation.Properties.PARENT, ShiftReconciliation.Properties.SHIFT}, new ObjectSearchFilter<TradingDay>(Shift.Properties.TRADING_DAY));
        this.dateFilter = new ObjectSearchFilter<Date>(TradingDay.Properties.DATE);
        this.addSearchFilter(this.shiftFilter);
        this.addSearchFilter(this.tradingDayFilter);
    }

    public ObjectJoinSearchFilter<Shift> getShiftFilter() {
        return this.shiftFilter;
    }

    public ObjectJoinSearchFilter<TradingDay> getTradingDayFilter() {
        return this.tradingDayFilter;
    }

    public SingleValueQuerySearchFilter<Date> getFixedDateFilter() {
        return this.dateFilter;
    }

    @Override
    public ObjectQuery getObjectQuery() {
        TradingDay day;
        if (this.dateFilter.hasSearchValue() && (day = PersistenceManager.getObject(TradingDay.class, Query.select(TradingDay.class).equals(TradingDay.Properties.DATE, (Date)this.dateFilter.getSearchValue(), SQLDateType.DATE).toString())) != null) {
            this.tradingDayFilter.setSearchValue(day);
        }
        return super.getObjectQuery();
    }

    @Override
    protected ObjectQuery getBaseQuery() {
        ObjectQuery query = Query.select(ActualCashEntry.Properties.ID);
        query.select(CashdrawerReconciliation.Properties.CASHDRAWER).selectFunc("SUM(CEILING(finance_reconciliation_entry.value / finance_denomination.value)) as 'unit_count'").select("Reconciliation", "name").select(ActualCashEntry.Properties.DENOMINATION).linkUsing(ActualCashEntry.Properties.PARENT).linkUsing(ActualCashEntry.Properties.DENOMINATION).groupBy(ActualCashEntry.Properties.DENOMINATION).groupBy(CashdrawerReconciliation.Properties.CASHDRAWER);
        return query;
    }
}

