/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.finance;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.filter.implementation.ObjectJoinSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectSearchFilter;
import au.com.ordermate.persistence.PropertiedObject;
import ordermate.database.finance.Shift;
import ordermate.database.finance.Skim;
import ordermate.database.finance.SkimTransaction;
import ordermate.database.finance.SkimTransactionEntry;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.finance.DenominationReport;

public class SkimsByDenominationSearcher
extends PropertySearcher<DenominationReport> {
    private ObjectSearchFilter<Shift> shiftFilter;
    private ObjectJoinSearchFilter<TradingDay> tradingDayFilter;

    public SkimsByDenominationSearcher() {
        super(DenominationReport.class);
        this.shiftFilter = new ObjectSearchFilter<Shift>(Skim.Properties.SHIFT);
        this.tradingDayFilter = new ObjectJoinSearchFilter<TradingDay>(new PropertiedObject.Property[]{Skim.Properties.SHIFT}, new ObjectSearchFilter<TradingDay>(Shift.Properties.TRADING_DAY));
        this.addSearchFilter(this.shiftFilter);
        this.addSearchFilter(this.tradingDayFilter);
    }

    public ObjectSearchFilter<Shift> getShiftFilter() {
        return this.shiftFilter;
    }

    public ObjectJoinSearchFilter<TradingDay> getTradingDayFilter() {
        return this.tradingDayFilter;
    }

    @Override
    protected ObjectQuery getBaseQuery() {
        ObjectQuery query = Query.select(SkimTransactionEntry.Properties.ID);
        query.select(Skim.Properties.CASH_DRAWER).sum(SkimTransactionEntry.Properties.UNIT_COUNT, "unit_count").selectFunc("DATE_FORMAT(" + Skim.Properties.CREATION_TIME + ",'%T') as 'name'").select(SkimTransactionEntry.Properties.DENOMINATION).linkUsing(SkimTransactionEntry.Properties.SKIM_TRANSACTION).linkUsing(SkimTransaction.Properties.SKIM).active(SkimTransaction.class).active(Skim.class).groupBy(SkimTransactionEntry.Properties.DENOMINATION).groupBy(Skim.Properties.CASH_DRAWER);
        return query;
    }
}

