/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.futureorder;

import au.com.ordermate.persistence.PersistentSummaryObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.Price;
import java.math.BigDecimal;
import ordermate.database.sales.Account;
import ordermate.database.sales.SalesLineItem;

public class FutureOrderAccountSummary
extends PersistentSummaryObject {
    public static final Props Properties = new Props();
    private String accountInfo;
    private SalesLineItem item;
    private BigDecimal qty;
    private Price salesTotal;

    public FutureOrderAccountSummary(String accInfo, SalesLineItem it, BigDecimal qt, Price total) {
        this.accountInfo = accInfo;
        this.item = it;
        this.qty = qt;
        this.salesTotal = total;
    }

    public static String generateAccountString(Account acc) {
        StringBuilder sb = new StringBuilder();
        sb.append(acc.getCustomer() != null ? acc.getCustomer().getName() : acc.toString()).append(" ").append(acc.getAccountType().getLabel()).append(" ").append("Placed: ").append(DateTimeUtils.formatTimeForDisplay(acc.getCreationDateTime())).append(" - ").append(DateTimeUtils.getMediumDateFormat().format(acc.getCreationDateTime())).append(" ").append("Due: ").append(acc.getTimeDue() == null ? "" : DateTimeUtils.formatTimeForDisplay(acc.getTimeDue())).append(" - ").append(acc.getDateDue() == null ? "" : DateTimeUtils.getMediumDateFormat().format(acc.getDateDue()));
        return sb.toString();
    }

    public String getAccountInfo() {
        return this.accountInfo;
    }

    public SalesLineItem getItem() {
        return this.item;
    }

    public BigDecimal getQty() {
        return this.qty;
    }

    public Price getSalesTotal() {
        return this.salesTotal;
    }

    public static class Props
    extends PersistentSummaryObject.Props {
        public PropertiedObject.Property<String> ACCOUNT_INFO;
        public PropertiedObject.Property<SalesLineItem> ITEM;
        public PropertiedObject.Property<BigDecimal> QTY;
        public PropertiedObject.Property<Price> SALES_TOTAL;
    }
}

