/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.futureorder;

import au.com.ordermate.persistence.PersistentSummaryObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.Price;
import java.math.BigDecimal;
import ordermate.database.sales.SalesLineItem;

public class FutureOrderItemSummary
extends PersistentSummaryObject {
    public static final Props Properties = new Props();
    private String itemName;
    private BigDecimal totalQty;
    private Price totalSalesTotal;

    public FutureOrderItemSummary(String itemName) {
        this.itemName = itemName;
        this.totalQty = new BigDecimal(0.0);
        this.totalSalesTotal = Price.ZERO_DOLLAR;
    }

    public void addSalesItem(SalesLineItem item) {
        if (!item.toString().equals(this.itemName)) {
            throw new IllegalStateException("Cannot add " + item + " to the key of " + this.itemName);
        }
        this.totalQty = this.totalQty.add(item.getQuantity().getValue());
        this.totalSalesTotal = this.totalSalesTotal.add(item.getPrice());
    }

    public String getItemName() {
        return this.itemName;
    }

    public BigDecimal getTotalQty() {
        return this.totalQty;
    }

    public Price getTotalSalesTotal() {
        return this.totalSalesTotal;
    }

    public static class Props
    extends PersistentSummaryObject.Props {
        public PropertiedObject.Property<String> ITEM_NAME;
        public PropertiedObject.Property<BigDecimal> TOTAL_QTY;
        public PropertiedObject.Property<Price> TOTAL_SALES_TOTAL;
    }
}

