/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.futureorder;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.Executable;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PropertiedObject;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.database.reports.futureorder.FutureOrderReportCompiler;
import ordermate.database.reports.futureorder.FutureOrderReportProvider;
import ordermate.database.sales.Account;
import ordermate.database.searchers.sales.AccountSearcher;
import ordermate.docketprocessor.DocketProcessor;
import org.apache.commons.lang.ArrayUtils;

public class FutureOrderPrintExecutable
extends Executable<Boolean> {
    private final long[] accIDs;
    private final long virtualPrinterID;
    private final Date startDateDue;
    private final Date endDateDue;

    public FutureOrderPrintExecutable(List<Account> toPrint, VirtualPrinter toPrintTo, Date start, Date end) {
        this.accIDs = new long[toPrint.size()];
        for (int index = 0; index < toPrint.size(); ++index) {
            this.accIDs[index] = toPrint.get(index).getID();
        }
        this.virtualPrinterID = toPrintTo.getID();
        this.startDateDue = start;
        this.endDateDue = end;
    }

    @Override
    public Boolean execute() {
        OrderMate.LOG.info("Attempt Print Future Orders");
        List<Account> accounts = this.getAccounts();
        VirtualPrinter virtualPrinter = this.getVirtualPrinter();
        if (!this.validate(accounts, virtualPrinter)) {
            return Boolean.FALSE;
        }
        return (boolean)this.print(accounts, virtualPrinter);
    }

    private Boolean print(final List<Account> accounts, VirtualPrinter virtualPrinter) {
        FutureOrderReportProvider provider = new FutureOrderReportProvider(new FutureOrderReportCompiler(new AccountSearcher()){

            @Override
            public List<Account> getDataList() {
                return accounts;
            }

            @Override
            public Date getStartDateDue() {
                return FutureOrderPrintExecutable.this.startDateDue;
            }

            @Override
            public Date getEndDateDue() {
                return FutureOrderPrintExecutable.this.endDateDue;
            }
        });
        try {
            DocketProcessor.printReportPrintJob(provider.getReportPrint(), Arrays.asList(virtualPrinter));
        }
        catch (Exception e) {
            OrderMate.LOG.error("Could not print! ", (Throwable)e);
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private List<Account> getAccounts() {
        List<Account> reaquiredObjs = PersistenceManager.getObjectList(Account.class, Query.select(Account.class).wherePropertyIn(new PropertiedObject.Property(Account.class, Account.Properties.ID), Arrays.asList(ArrayUtils.toObject((long[])this.accIDs))).toString(), PersistenceManager.EMPTY_OBJECT_ARRAY);
        return reaquiredObjs;
    }

    private VirtualPrinter getVirtualPrinter() {
        return PersistenceManager.getByID(this.virtualPrinterID, VirtualPrinter.class);
    }

    private boolean validate(List<Account> accounts, VirtualPrinter virtualPrinter) {
        boolean isValid = true;
        if (!(isValid &= accounts.size() == this.accIDs.length)) {
            OrderMate.LOG.error("unexpected number of accounts returned for FutureOrderPrintExecutable - a given account ID was not found in the database!");
            return isValid;
        }
        if (!(isValid &= virtualPrinter != null)) {
            OrderMate.LOG.error("virtualPrinter of id " + this.virtualPrinterID + " did not exist in the database!");
        }
        return isValid;
    }
}

