/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.futureorder;

import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.annotation.FilterConfig;
import au.com.ordermate.oquery.search.filter.implementation.DateRangeSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.RangeQuerySearchFilter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import ordermate.database.reports.futureorder.FutureOrderAccountSummary;
import ordermate.database.reports.futureorder.FutureOrderItemSummary;
import ordermate.database.sales.Account;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.searchers.sales.AccountSearcher;

public class FutureOrderReportCompiler {
    private AccountSearcher searcher;

    public FutureOrderReportCompiler(AccountSearcher searcher) {
        this.searcher = searcher;
    }

    public List<FutureOrderAccountSummary> compile() {
        return this.compileData(this.getDataList());
    }

    public List<Account> getDataList() {
        return this.getSearcher().search();
    }

    private List<FutureOrderAccountSummary> compileData(List<Account> search) {
        ArrayList<FutureOrderAccountSummary> summs = new ArrayList<FutureOrderAccountSummary>();
        for (Account acc : search) {
            String accHandle = FutureOrderAccountSummary.generateAccountString(acc);
            for (SalesLineItem salesLineItem : acc.getItems()) {
                summs.add(new FutureOrderAccountSummary(accHandle, salesLineItem, salesLineItem.getQuantity().getValue(), salesLineItem.getPrice()));
            }
        }
        return summs;
    }

    public AccountSearcher getSearcher() {
        return this.searcher;
    }

    public List<FutureOrderItemSummary> compileSummary() {
        return this.compileSummaryData(this.getDataList());
    }

    private List<FutureOrderItemSummary> compileSummaryData(List<Account> search) {
        ArrayList<FutureOrderItemSummary> itemSumms = new ArrayList<FutureOrderItemSummary>();
        HashMap<String, FutureOrderItemSummary> myMap = new HashMap<String, FutureOrderItemSummary>();
        for (Account acc : search) {
            for (SalesLineItem salesLineItem : acc.getItems()) {
                String key = salesLineItem.toString();
                if (!myMap.containsKey(key)) {
                    myMap.put(key, new FutureOrderItemSummary(key));
                }
                ((FutureOrderItemSummary)myMap.get(key)).addSalesItem(salesLineItem);
            }
        }
        itemSumms.addAll(myMap.values());
        return itemSumms;
    }

    public Date getStartDateDue() {
        DateRangeSearchFilter dateFilter = this.getSearcher().getDateDueRangeSearch();
        return (Date)dateFilter.getStart();
    }

    public Date getEndDateDue() {
        DateRangeSearchFilter dateFilter = this.getSearcher().getDateDueRangeSearch();
        return (Date)dateFilter.getEnd();
    }

    public List getAccountTypeList() {
        return this.getSearcher().getAccountTypeListSearch().getSelectedOptions();
    }

    @FilterConfig(name="Date Range", dateType=SQLDateType.DATE, dataType=Date.class, plural=FilterConfig.Plural.Ranged, nullAllowed=false, priority=true, sequence=1)
    public RangeQuerySearchFilter getDateRangeFilter() {
        return this.getSearcher().getDateRangeSearch();
    }
}

