/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.futureorder;

import au.com.ordermate.reports.MakesReport;
import au.com.ordermate.reports.ReportConfigureColumnMetaData;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.futureorder.FutureOrderReportCompiler;
import ordermate.database.reports.futureorder.FutureOrderReportProvider;
import ordermate.database.reports.maker.ConfigurableReportMaker;
import ordermate.database.searchers.sales.AccountSearcher;

@MakesReport(value="Open Orders", description="Orders that are currently open, including account name, the items and quantity on order and the sales value", category="General", columnMetaData={@ReportConfigureColumnMetaData(name="Qty", totaled=true), @ReportConfigureColumnMetaData(name="Item", locked=true), @ReportConfigureColumnMetaData(name="Item Name", locked=true), @ReportConfigureColumnMetaData(name="Sales Total", totaled=true), @ReportConfigureColumnMetaData(name="Total Qty", totaled=true), @ReportConfigureColumnMetaData(name="Total Sales Total", totaled=true)})
public class FutureOrderReportMaker
extends ConfigurableReportMaker<FutureOrderReportCompiler, FutureOrderReportProvider> {
    @Override
    protected FutureOrderReportCompiler createSearchFilter() {
        AccountSearcher searcher = new AccountSearcher();
        searcher.setStartDateRange(TradingDay.getCurrentTradingDay().getDate());
        searcher.setEndDateRange(TradingDay.getCurrentTradingDay().getDate());
        return new FutureOrderReportCompiler(searcher);
    }

    @Override
    protected FutureOrderReportProvider createReportProvider(FutureOrderReportCompiler yourSearcher) {
        return new FutureOrderReportProvider(yourSearcher);
    }
}

