/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.futureorder;

import ar.com.fdvs.dj.core.layout.ClassicLayoutManager;
import ar.com.fdvs.dj.core.layout.LayoutManager;
import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.builders.BuilderException;
import ar.com.fdvs.dj.domain.builders.ColumnBuilderException;
import ar.com.fdvs.dj.domain.builders.DJBuilderException;
import ar.com.fdvs.dj.domain.constants.GroupLayout;
import ar.com.fdvs.dj.domain.entities.DJGroup;
import ar.com.fdvs.dj.domain.entities.columns.PropertyColumn;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import ordermate.OrderMate;
import ordermate.database.reports.ReportProviderHelper;
import ordermate.database.reports.futureorder.FutureOrderAccountSummary;
import ordermate.database.reports.futureorder.FutureOrderItemSummary;
import ordermate.database.reports.futureorder.FutureOrderReportCompiler;
import ordermate.database.sales.AccountType;
import ordermate.database.searchers.sales.AccountSearcher;
import ordermate.reports.dynamicjasper.OrderMateDefaultReportStyle;
import ordermate.reports.dynamicjasper.OrdermateSmallTextReportStyle;
import ordermate.reports.dynamicjasper.ReportBuilder;
import ordermate.reports.dynamicjasper.reportbuilder.AbstractReportProvider;

public class FutureOrderReportProvider
extends AbstractReportProvider {
    private static final String FUTURE_ORDER_DATA = "FUTURE_ORDER_DATA";
    private static final String FUTURE_ORDER_DATA_SUM = "FUTURE_ORDER_DATA_SUM";
    private FutureOrderReportCompiler compiler;

    public FutureOrderReportProvider(FutureOrderReportCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public JRRewindableDataSource getDataSource() {
        return this.wrapData(this.compiler.compile());
    }

    public JRRewindableDataSource wrapData(List reportList) {
        return new JRBeanCollectionDataSource((Collection)reportList);
    }

    @Override
    protected DynamicReport getReport() throws BuilderException {
        this.addParam(FUTURE_ORDER_DATA, this.wrapData(this.compiler.compile()));
        this.addParam(FUTURE_ORDER_DATA_SUM, this.wrapData(this.compiler.compileSummary()));
        return this.getBuilder().buildJasperReport();
    }

    @Override
    public ReportBuilder getBuilder() throws BuilderException {
        ReportBuilder builder = new ReportBuilder(new OrdermateSmallTextReportStyle());
        this.getParameters().putAll(builder.addBusinessLogoDetailHeaderAndFooterTemplate());
        builder.setTitle("Open Orders Report");
        builder.setSubtitle(this.generateSubTitle());
        try {
            builder.getReportBuilder().addConcatenatedReport(this.generateMainReport(), (LayoutManager)new ClassicLayoutManager(), FUTURE_ORDER_DATA, 0, 10, false);
            builder.getReportBuilder().addConcatenatedReport(this.generateSubReport(), (LayoutManager)new ClassicLayoutManager(), FUTURE_ORDER_DATA_SUM, 0, 10, false);
        }
        catch (DJBuilderException ex) {
            OrderMate.LOG.warn("Cannot build sub reports", (Throwable)ex);
        }
        builder.getReportBuilder().setAllowDetailSplit(true);
        return builder;
    }

    private String generateSubTitle() {
        StringBuilder subTitle = new StringBuilder();
        if (!this.compiler.getAccountTypeList().isEmpty()) {
            List accTypes = this.compiler.getAccountTypeList();
            for (Object obj : accTypes) {
                if (!(obj instanceof AccountType)) continue;
                subTitle.append(((AccountType)obj).getLabel());
                subTitle.append(", ");
            }
            subTitle.delete(subTitle.length() - 2, subTitle.length());
            subTitle.append(" ");
        }
        AccountSearcher searcher = this.compiler.getSearcher();
        ReportProviderHelper helper = this.getHelper();
        helper.appendRangeSearchFilter(subTitle, "Due", searcher.getDateDueRangeSearch(), helper.getDateFormat());
        helper.appendRangeSearchFilter(subTitle, "Created", searcher.getDateRangeSearch(), helper.getDateFormat());
        helper.appendSearchFilter(subTitle, "Customer", searcher.getCustomerSearch());
        helper.appendSearchFilter(subTitle, "Account Type", searcher.getAccountTypeListSearch());
        helper.appendSearchFilter(subTitle, "Account ID", searcher.getIDSearch());
        helper.appendRangeSearchFilter(subTitle, "Time Due", searcher.getTimeDueSearch(), helper.getTimeFormat());
        helper.appendSearchFilter(subTitle, "Opened by", searcher.getOpenedByUser());
        helper.appendSearchFilter(subTitle, "Closed by", searcher.getClosedByUser());
        helper.appendSearchFilter(subTitle, "Customers", searcher.getMultiCustomerSearch());
        helper.appendSearchFilter(subTitle, "Account State", searcher.getAccountStateSearch());
        helper.appendSearchFilter(subTitle, "Receipt State", searcher.getReceiptPrintStateSearch());
        helper.appendSearchFilter(subTitle, "Shift", searcher.getFinanceShiftSearch());
        helper.appendSearchFilter(subTitle, "Shift Name", searcher.getShiftNameSearch());
        helper.appendRangeSearchFilter(subTitle, "Amount", searcher.getFinanceTransactionAmountRangeSearch(), null);
        helper.appendRangeSearchFilter(subTitle, "Total", searcher.getSavedTotalSearch(), null);
        helper.appendSearchFilter(subTitle, "Type", searcher.getAccountTypeListSearch());
        helper.appendSearchFilter(subTitle, "Unit", searcher.getPaymentTypeSearch());
        helper.appendSearchFilter(subTitle, "Terminal", searcher.getTerminalSearch());
        helper.appendSearchFilter(subTitle, "Paid Off", searcher.getPayOffDayFilter());
        helper.appendSearchFilter(subTitle, "Driver", searcher.getDeliveryDriverSearch());
        helper.appendSearchFilter(subTitle, "Source", searcher.getOrderSourceListSearch());
        helper.appendSearchFilter(subTitle, "Sales Location", searcher.getSalesLocationFilter());
        return subTitle.toString();
    }

    private DynamicReport generateSubReport() throws ColumnBuilderException {
        ReportBuilder builder = new ReportBuilder();
        builder.addReportColumns(Arrays.asList(FutureOrderItemSummary.Properties.ITEM_NAME, FutureOrderItemSummary.Properties.TOTAL_QTY, FutureOrderItemSummary.Properties.TOTAL_SALES_TOTAL));
        builder.addFooterCalculation(new ReportBuilder.PropertyCalculation(FutureOrderItemSummary.Properties.TOTAL_QTY, DJCalculation.SUM));
        builder.addFooterCalculation(new ReportBuilder.PropertyCalculation(FutureOrderItemSummary.Properties.TOTAL_SALES_TOTAL, DJCalculation.SUM));
        builder.getReportBuilder().setGrandTotalLegend("Total");
        builder.getReportBuilder().setGrandTotalLegendStyle(new OrderMateDefaultReportStyle().getFooterVariableStyle());
        return builder.buildJasperReport();
    }

    private DynamicReport generateMainReport() throws ColumnBuilderException {
        ReportBuilder builder = new ReportBuilder();
        builder.addReportColumns(Arrays.asList(FutureOrderAccountSummary.Properties.ACCOUNT_INFO, FutureOrderAccountSummary.Properties.ITEM, FutureOrderAccountSummary.Properties.QTY, FutureOrderAccountSummary.Properties.SALES_TOTAL));
        DJGroup group = builder.addGroupBy(FutureOrderAccountSummary.Properties.ACCOUNT_INFO, Arrays.asList(new ReportBuilder.PropertyCalculation(FutureOrderAccountSummary.Properties.SALES_TOTAL, DJCalculation.SUM), new ReportBuilder.PropertyCalculation(FutureOrderAccountSummary.Properties.QTY, DJCalculation.SUM)));
        group.setLayout(GroupLayout.VALUE_IN_HEADER_WITH_HEADERS_AND_COLUMN_NAME);
        group.setReprintHeaderOnEachPage(Boolean.TRUE);
        group.setAllowHeaederSplit(false);
        group.setAllowFooterSplit(false);
        group.setHeaderHeight(Integer.valueOf(15));
        PropertyColumn groupCol = builder.getPropertyColumn(FutureOrderAccountSummary.Properties.ACCOUNT_INFO);
        this.hideColumnName(groupCol);
        return builder.buildJasperReport();
    }

    @Override
    protected String getAdditionalFooterText() {
        return null;
    }
}

