/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.general;

import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentSummaryObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.Price;
import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Transient;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@AccessType(value="property")
public class QuantitySoldReport
extends PersistentSummaryObject {
    public static final Props Properties = new Props();
    private BigDecimal quantitySold = BigDecimal.ZERO;
    private Price unitPrice = Price.ZERO_NO_ROUND;

    @Override
    public void init() {
        if (this.getUnitPrice() == null) {
            this.setUnitPrice(Price.ZERO_NO_ROUND);
        }
        super.init();
    }

    @Column(name="quantity_sold")
    public BigDecimal getQuantitySold() {
        return this.quantitySold;
    }

    @Column(name="unit_price")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.001")})
    public Price getUnitPrice() {
        return this.unitPrice != null ? this.unitPrice : Price.ZERO_NO_ROUND;
    }

    @Transient
    public Price getSalesValue() {
        return new Price(this.getUnitPrice().multiply(this.quantitySold), 0.0);
    }

    @Transient
    public Double getSalesValueRaw() {
        return new Double(this.getSalesValue().doubleValue());
    }

    public void setUnitPrice(Price unitPrice) {
        this.unitPrice = unitPrice;
    }

    public void setQuantitySold(BigDecimal qty) {
        this.quantitySold = qty;
    }

    public void addReport(QuantitySoldReport report) {
        this.quantitySold = this.quantitySold.add(report.getQuantitySold());
        this.unitPrice = this.unitPrice.add(report.getUnitPrice());
    }

    public static class Props
    extends PersistentSummaryObject.Props {
        public PropertiedObject.Property QUANTITY_SOLD;
        public PropertiedObject.Property UNIT_PRICE;
        public PersistentObject.DerivedProperty<Price> SALES_VALUE = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)QuantitySoldReport.class), "salesValue");
        public PersistentObject.DerivedProperty<Double> SALES_VALUE_RAW = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)QuantitySoldReport.class), "salesValueRaw");
    }
}

