/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.hourlysales;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.Price;
import java.math.BigDecimal;

public final class HourlySalesCollation
implements PropertiedObject {
    public static final Props Properties = new Props();
    private static final int NUM_PERIODS = 24;
    private Long id;
    private BigDecimal qtyTotal;
    private Price salesTotal;
    private String label;
    private BigDecimal[] qtyData = new BigDecimal[24];
    private Price[] salesData = new Price[24];

    public HourlySalesCollation(Long yourId, String yourLabel, Price yourSales, BigDecimal yourQty) {
        this.id = yourId;
        this.label = yourLabel;
        this.salesTotal = yourSales;
        this.qtyTotal = yourQty;
        for (int i = 0; i < this.qtyData.length; ++i) {
            this.qtyData[i] = yourQty;
            this.salesData[i] = yourSales;
        }
    }

    public void doTotal() {
        double tally = 0.0;
        for (BigDecimal bigDecimal : this.qtyData) {
            if (bigDecimal == null) continue;
            tally += bigDecimal.doubleValue();
        }
        this.qtyTotal = new BigDecimal(tally);
        tally = 0.0;
        for (Number number : this.salesData) {
            if (number == null) continue;
            tally += ((Price)number).doubleValue();
        }
        this.salesTotal = new Price(tally, 0.01);
    }

    public final Long getId() {
        return this.id;
    }

    public final BigDecimal getQtyTotal() {
        return this.qtyTotal;
    }

    public final Price getSalesTotal() {
        return this.salesTotal;
    }

    public final String getLabel() {
        return this.label;
    }

    public final BigDecimal[] getQtyData() {
        return this.qtyData;
    }

    public final Price[] getSalesData() {
        return this.salesData;
    }

    @Override
    public Props getProperties() {
        return Properties;
    }

    @Override
    public <T> T getPropertyValue(PropertiedObject.Property<T> prop) {
        return PropertiedObject.PropsHelper.getPropertyValue(this, prop);
    }

    public static class Props
    extends PropertiedObject.Props {
        public PropertiedObject.Property<Long> ID;
        public PropertiedObject.Property<BigDecimal> QTY_TOTAL;
        public PropertiedObject.Property<Price> SALES_TOTAL;
        public PropertiedObject.Property<String> LABEL;
        public PropertiedObject.Property<Price[]> SALES_DATA;
        public PropertiedObject.Property<BigDecimal[]> QTY_DATA;
    }
}

