/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.hourlysales;

import au.com.ordermate.util.Price;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import ordermate.database.reports.hourlysales.HourlySalesCollation;
import ordermate.database.reports.hourlysales.HourlySalesReport;
import ordermate.database.reports.hourlysales.HourlySalesTableData;

public class HourlySalesCompiler {
    List<HourlySalesCollation> collatedList;
    Price defaultPrice;
    BigDecimal defaultQty;
    private HourlySalesTableData data;

    public HourlySalesCompiler(HourlySalesTableData data) {
        this.data = data;
        this.defaultPrice = Price.ZERO_DOLLAR;
        this.defaultQty = new BigDecimal(0.0);
    }

    public List<HourlySalesCollation> compileReports() {
        List<HourlySalesReport> reports = this.data.getSearcher().search();
        this.collatedList = new ArrayList<HourlySalesCollation>();
        LinkedHashMap<Long, HourlySalesCollation> collations = new LinkedHashMap<Long, HourlySalesCollation>();
        for (HourlySalesReport report : reports) {
            if (!collations.containsKey(report.getGroupingId())) {
                collations.put(report.getGroupingId(), new HourlySalesCollation(report.getGroupingId(), report.getGroupingLabel(), this.defaultPrice, this.defaultQty));
            }
            ((HourlySalesCollation)collations.get((Object)report.getGroupingId())).getQtyData()[report.getTimeBracket().intValue()] = report.getQuantitySold();
            ((HourlySalesCollation)collations.get((Object)report.getGroupingId())).getSalesData()[report.getTimeBracket().intValue()] = report.getSales();
        }
        for (HourlySalesCollation collation : collations.values()) {
            collation.doTotal();
            this.collatedList.add(collation);
        }
        this.data.setDataList(this.collatedList);
        return this.collatedList;
    }

    public HourlySalesTableData getData() {
        return this.data;
    }
}

