/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.hourlysales;

import ar.com.fdvs.dj.domain.ColumnProperty;
import ar.com.fdvs.dj.domain.CustomExpression;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.BuilderException;
import ar.com.fdvs.dj.domain.builders.ColumnBuilderException;
import ar.com.fdvs.dj.domain.constants.Rotation;
import ar.com.fdvs.dj.domain.constants.Stretching;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.columns.ExpressionColumn;
import java.util.Map;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import ordermate.database.reports.ReportProviderHelper;
import ordermate.database.reports.hourlysales.HourlySalesCollation;
import ordermate.database.reports.hourlysales.HourlySalesTableData;
import ordermate.database.reports.hourlysales.HourlySalesValueType;
import ordermate.internationalization.Internationalization;
import ordermate.reports.dynamicjasper.OrderMateDefaultReportStyle;
import ordermate.reports.dynamicjasper.OrdermateSmallTextReportStyle;
import ordermate.reports.dynamicjasper.ReportBuilder;
import ordermate.reports.dynamicjasper.customexpressions.ArrayResolverExpression;
import ordermate.reports.dynamicjasper.reportbuilder.AbstractReportProvider;

public class HourlySalesJasperReportProvider
extends AbstractReportProvider {
    private ReportBuilder builder;
    private JRRewindableDataSource datasource;
    private HourlySalesTableData data;

    public HourlySalesJasperReportProvider(HourlySalesTableData yourData) {
        this.data = yourData;
    }

    @Override
    public JRRewindableDataSource getDataSource() {
        this.datasource = new JRBeanCollectionDataSource(this.data.getReportList());
        return this.datasource;
    }

    @Override
    protected DynamicReport getReport() throws BuilderException {
        this.initBuilder();
        return this.builder.buildJasperReport();
    }

    private void initBuilder() throws ColumnBuilderException {
        this.builder = new ReportBuilder(new OrdermateSmallTextReportStyle(), ReportBuilder.TemplateFormat.A4Landscape);
        this.getParameters().putAll(this.builder.addBusinessLogoDetailHeaderAndFooterTemplate());
        this.builder.setTitle("Hourly Sales");
        StringBuilder SB = new StringBuilder();
        this.getHelper().appendSearchFilter(SB, "Trading Day", this.data.getSearcher().getTradingDayFilter());
        this.getHelper().appendSearchFilter(SB, "Sales Location", this.data.getSearcher().getSalesLocationFilter());
        this.builder.setSubtitle(SB.toString());
        String arrayName = HourlySalesCollation.Properties.SALES_DATA.getName();
        String format = null;
        Style rotatedStyle = new OrderMateDefaultReportStyle().getColumnHeaderStyle();
        rotatedStyle.setStreching(Stretching.RELATIVE_TO_TALLEST_OBJECT);
        rotatedStyle.setStretchWithOverflow(false);
        rotatedStyle.setRotation(Rotation.RIGHT);
        this.builder.getReportBuilder().setHeaderHeight(80);
        this.builder.addReportColumn(HourlySalesCollation.Properties.LABEL, this.data.getColumnLabel(), null);
        if (HourlySalesValueType.Sales.equals((Object)this.data.getValueType())) {
            this.builder.addReportColumn(HourlySalesCollation.Properties.SALES_TOTAL, "Total Sales", Internationalization.getLiteralFor("DOLLAR_SIGN") + "0.00");
            this.builder.addInvisibleField(HourlySalesCollation.Properties.SALES_DATA);
        } else {
            format = "#0.#";
            this.builder.addReportColumn(HourlySalesCollation.Properties.QTY_TOTAL, "Total Quantity", "0");
            this.builder.addInvisibleField(HourlySalesCollation.Properties.QTY_DATA);
            arrayName = HourlySalesCollation.Properties.QTY_DATA.getName();
        }
        Map<Integer, Object> cols = this.data.getVisibleDataColumns();
        Style colStyle = new OrdermateSmallTextReportStyle().getColumnDetailStyle();
        for (int i = 0; i < 24; ++i) {
            Object columnId = cols.get(i);
            if (columnId == null || !this.data.isVisible(columnId) || HourlySalesCollation.Properties.SALES_TOTAL.equals(columnId) || HourlySalesCollation.Properties.QTY_TOTAL.equals(columnId)) continue;
            ExpressionColumn column = new ExpressionColumn();
            column.setColumnProperty(new ColumnProperty(String.valueOf(columnId), HourlySalesCollation.class));
            column.setExpression((CustomExpression)new ArrayResolverExpression(arrayName, i));
            column.setTitle(this.makeTitle(i));
            column.setHeaderStyle(rotatedStyle);
            column.setStyle(colStyle);
            column.setWidth(Integer.valueOf(30));
            if (format != null) {
                column.setPattern(format);
            }
            this.builder.getReportBuilder().addColumn((AbstractColumn)column);
        }
    }

    private String makeTitle(int index) {
        StringBuilder SB = new StringBuilder();
        SB.append(index).append(":00 - ").append(index + 1).append(":00");
        return SB.toString();
    }

    @Override
    public ReportBuilder getBuilder() throws BuilderException {
        if (this.builder == null) {
            this.initBuilder();
        }
        return this.builder;
    }

    @Override
    protected String getAdditionalFooterText() {
        if (this.data.getSearcher().getTradingDayFilter().hasSearchValue()) {
            return "Sales in this report are being filtered based on " + ReportProviderHelper.describeSingleValueFilter(this.data.getSearcher().getTradingDayFilter());
        }
        return null;
    }
}

