/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.hourlysales;

import au.com.ordermate.util.Price;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ordermate.database.reports.hourlysales.HourlySalesCollation;
import ordermate.database.reports.hourlysales.HourlySalesCompiler;
import ordermate.database.reports.hourlysales.HourlySalesValueType;
import ordermate.database.searchers.reports.hourlysales.HourlySalesReportSearcher;

public class HourlySalesTableData {
    private Map<Integer, Object> qtyCols;
    private Map<Integer, Object> salesCols;
    private Map<Object, Boolean> visibilityMap;
    private HourlySalesValueType valueType = HourlySalesValueType.Sales;
    private String label;
    private HourlySalesReportSearcher searcher;
    private List<HourlySalesCollation> reportList;
    private boolean hideZeroes = false;

    public HourlySalesTableData(HourlySalesReportSearcher searcher, String label) {
        this.searcher = searcher;
        this.label = label;
        this.initWebSearchFilter();
    }

    private void initWebSearchFilter() {
        this.valueType = this.searcher.getValueTypeFilterValue();
        this.hideZeroes = this.searcher.getHideZeroFilterValue();
        if (this.hideZeroes) {
            this.getReportList();
        }
    }

    public void init() {
        this.qtyCols = new HashMap<Integer, Object>();
        this.salesCols = new HashMap<Integer, Object>();
        this.visibilityMap = new HashMap<Object, Boolean>();
        this.initColumns();
    }

    private void initColumns() {
        for (int i = 0; i < 24; ++i) {
            StringBuilder SB = new StringBuilder("<html>");
            SB.append(i).append(":00-<br> ").append(i + 1).append(":00</html>");
            String columnId = HourlySalesCollation.Properties.SALES_DATA.getName() + "[" + i + "]";
            this.salesCols.put(i, columnId);
            this.visibilityMap.put(columnId, Boolean.TRUE);
            columnId = HourlySalesCollation.Properties.QTY_DATA.getName() + "[" + i + "]";
            this.qtyCols.put(i, columnId);
            this.visibilityMap.put(columnId, Boolean.FALSE);
        }
        this.visibilityMap.put(HourlySalesCollation.Properties.QTY_TOTAL, Boolean.FALSE);
        this.visibilityMap.put(HourlySalesCollation.Properties.SALES_TOTAL, Boolean.TRUE);
        this.updateColumnVisibility();
    }

    public HourlySalesReportSearcher getSearcher() {
        return this.searcher;
    }

    public String getColumnLabel() {
        return this.label;
    }

    public HourlySalesValueType getValueType() {
        return this.valueType;
    }

    public void setValueType(HourlySalesValueType value) {
        this.valueType = value;
    }

    public List<HourlySalesCollation> getReportList() {
        if (this.reportList != null) {
            return this.reportList;
        }
        HourlySalesCompiler compiler = new HourlySalesCompiler(this);
        return compiler.compileReports();
    }

    public Map<Integer, Object> getVisibleDataColumns() {
        if (HourlySalesValueType.Sales.equals((Object)this.getValueType())) {
            return this.salesCols;
        }
        return this.qtyCols;
    }

    public boolean isVisible(Object columnId) {
        return Boolean.TRUE.equals(this.visibilityMap.get(columnId));
    }

    public Map<Integer, Object> getQuantityCols() {
        return this.qtyCols;
    }

    public Map<Integer, Object> getSalesCols() {
        return this.salesCols;
    }

    public void updateColumnVisibility() {
        Map<Integer, Object> colsShow = null;
        Map<Integer, Object> colsHide = null;
        if (HourlySalesValueType.Quantity.equals((Object)this.valueType)) {
            colsShow = this.qtyCols;
            colsHide = this.salesCols;
        } else if (HourlySalesValueType.Sales.equals((Object)this.valueType)) {
            colsShow = this.salesCols;
            colsHide = this.qtyCols;
        } else {
            throw new IllegalStateException("Unknown Hourly Sales type :" + (Object)((Object)this.valueType));
        }
        for (Object columnId : colsShow.values()) {
            this.visibilityMap.put(columnId, Boolean.TRUE);
        }
        for (Object columnId : colsHide.values()) {
            this.visibilityMap.put(columnId, Boolean.FALSE);
        }
        this.hideZeroes();
    }

    private void hideZeroes() {
        Map<Integer, Object> cols = this.getSalesCols();
        Number zero = Price.ZERO_DOLLAR;
        if (HourlySalesValueType.Quantity.equals((Object)this.valueType)) {
            cols = this.qtyCols;
            zero = new BigDecimal(0);
        }
        if (!this.hideZeroes) {
            for (Object columnId : cols.values()) {
                this.visibilityMap.put(columnId, Boolean.TRUE);
            }
            return;
        }
        for (Integer index : cols.keySet()) {
            int intIndex = index;
            if (intIndex < 0) continue;
            boolean isZero = true;
            for (HourlySalesCollation nextReport : this.reportList) {
                if (HourlySalesValueType.Sales.equals((Object)this.valueType)) {
                    if (zero.equals(nextReport.getSalesData()[intIndex])) continue;
                    isZero = false;
                    break;
                }
                if (zero.equals(nextReport.getQtyData()[intIndex])) continue;
                isZero = false;
                break;
            }
            if (!isZero) continue;
            this.visibilityMap.put(cols.get(index), Boolean.FALSE);
        }
    }

    public void setHideZeroes(boolean value) {
        this.hideZeroes = value;
    }

    public Map<Object, Boolean> getColumnVisibility() {
        return this.visibilityMap;
    }

    public void setDataList(List<HourlySalesCollation> collated) {
        this.reportList = collated;
    }
}

