/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.itemgp;

import ar.com.fdvs.dj.domain.ColumnProperty;
import ar.com.fdvs.dj.domain.CustomExpression;
import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.DJValueFormatter;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.builders.BuilderException;
import ar.com.fdvs.dj.domain.builders.GroupBuilder;
import ar.com.fdvs.dj.domain.constants.GroupLayout;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.columns.PropertyColumn;
import ar.com.fdvs.dj.domain.entities.columns.SimpleColumn;
import au.com.ordermate.persistence.ArrayObject;
import java.text.Format;
import java.text.NumberFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import ordermate.database.reports.itemgp.ItemGPQueries;
import ordermate.database.reports.itemgp.ItemGPSearcher;
import ordermate.internationalization.Internationalization;
import ordermate.reports.dynamicjasper.OrderMateMinimalistStyle;
import ordermate.reports.dynamicjasper.ReportBuilder;
import ordermate.reports.dynamicjasper.customexpressions.PriceExpressionBuilder;
import ordermate.reports.dynamicjasper.reportbuilder.AbstractReportProvider;

public class ItemGPProvider
extends AbstractReportProvider {
    private ItemGPSearcher searcher;

    public ItemGPProvider(ItemGPSearcher searcher) {
        this.searcher = searcher;
    }

    @Override
    public JRRewindableDataSource getDataSource() {
        List<ArrayObject> list = this.searcher.search();
        Object[][] data = new Object[list.size()][];
        for (int row = 0; row < list.size(); ++row) {
            ArrayObject obj = list.get(row);
            Object[] rowData = obj.getArray();
            data[row] = rowData;
            for (int i = 4; i < rowData.length; ++i) {
                if (rowData[i] != null) continue;
                rowData[i] = 0.0;
            }
        }
        DefaultTableModel model = new DefaultTableModel(data, ItemGPQueries.displayColumns);
        return new JRTableModelDataSource((TableModel)model);
    }

    @Override
    protected DynamicReport getReport() throws BuilderException {
        return this.getBuilder().buildJasperReport();
    }

    @Override
    public ReportBuilder getBuilder() throws BuilderException {
        OrderMateMinimalistStyle style = new OrderMateMinimalistStyle();
        ReportBuilder builder = new ReportBuilder(style);
        builder.addMinimalistBusinessDetails();
        builder.setTitle("Item GP");
        StringBuilder SB = new StringBuilder("As of " + this.getHelper().getDateFormat().format(new Date()));
        this.getHelper().appendSearchFilter(SB, "Profile", this.searcher.getProfileFilter());
        this.getHelper().appendSearchFilter(SB, "Section", this.searcher.getGroupFilter());
        builder.setSubtitle(SB.toString());
        int PERC_COLUMN = 8;
        for (int i = 0; i < ItemGPQueries.displayColumns.length; ++i) {
            Class clazz = String.class;
            if (i > 4) {
                clazz = Double.class;
            }
            AbstractColumn column = this.makeColumn(i, clazz);
            if (i == PERC_COLUMN) {
                column.setTextFormatter((Format)NumberFormat.getPercentInstance());
            } else if (i > 4) {
                column.setTextFormatter((Format)NumberFormat.getCurrencyInstance());
                column.setPattern(Internationalization.getLiteralFor("DOLLAR_SIGN") + "0.00");
            }
            builder.getReportBuilder().addColumn(column);
            if (i == PERC_COLUMN) {
                builder.getReportBuilder().addGlobalFooterVariable(column, this.createPercentageGPExpression(true), style.getFooterVariableStyle());
                continue;
            }
            if (i <= 4) continue;
            builder.getReportBuilder().addGlobalFooterVariable(column, DJCalculation.SUM, style.getFooterVariableStyle(), new PriceExpressionBuilder.DJPriceFormatter());
        }
        if (Boolean.TRUE.equals(this.searcher.getGroupedFilter().getSearchValue())) {
            GroupBuilder groupBuilder = new GroupBuilder();
            groupBuilder.setCriteriaColumn((PropertyColumn)builder.getReportBuilder().getColumn(0));
            groupBuilder.addFooterVariable(builder.getReportBuilder().getColumn(5), DJCalculation.SUM, style.getFooterVariableStyle(), (DJValueFormatter)new PriceExpressionBuilder.DJPriceFormatter());
            groupBuilder.addFooterVariable(builder.getReportBuilder().getColumn(6), DJCalculation.SUM, style.getFooterVariableStyle(), (DJValueFormatter)new PriceExpressionBuilder.DJPriceFormatter());
            groupBuilder.addFooterVariable(builder.getReportBuilder().getColumn(7), DJCalculation.SUM, style.getFooterVariableStyle(), (DJValueFormatter)new PriceExpressionBuilder.DJPriceFormatter());
            groupBuilder.addFooterVariable(builder.getReportBuilder().getColumn(8), this.createPercentageGPExpression(false), style.getFooterVariableStyle());
            groupBuilder.addFooterVariable(builder.getReportBuilder().getColumn(9), DJCalculation.SUM, style.getFooterVariableStyle(), (DJValueFormatter)new PriceExpressionBuilder.DJPriceFormatter());
            groupBuilder.setGroupLayout(GroupLayout.VALUE_IN_HEADER);
            builder.getReportBuilder().addGroup(groupBuilder.build());
        }
        return builder;
    }

    private CustomExpression createPercentageGPExpression(final boolean global) {
        return new CustomExpression(){

            public Object evaluate(Map fields, Map variables, Map parameters) {
                Double GP = global ? (Double)variables.get("variable-footer_global_GP") : (Double)variables.get("variable-footer_Group_GP");
                Double costEx = global ? (Double)variables.get("variable-footer_global_Est. Cost Ex") : (Double)variables.get("variable-footer_Group_Est. Cost Ex");
                double result = GP / (GP + costEx);
                return NumberFormat.getPercentInstance().format(result);
            }

            public String getClassName() {
                return String.class.getName();
            }
        };
    }

    private AbstractColumn makeColumn(int index, Class clazz) {
        SimpleColumn column = new SimpleColumn();
        column.setName(ItemGPQueries.displayColumns[index]);
        column.setTitle(ItemGPQueries.displayColumns[index]);
        ColumnProperty prop = new ColumnProperty(ItemGPQueries.displayColumns[index], clazz);
        column.setColumnProperty(prop);
        return column;
    }

    @Override
    protected String getAdditionalFooterText() {
        return null;
    }

    class ArrayGetter
    implements CustomExpression {
        private final int index;

        ArrayGetter(int index) {
            this.index = index;
        }

        public Object evaluate(Map fields, Map variables, Map parameters) {
            System.out.println(fields);
            return null;
        }

        public String getClassName() {
            return String.class.getName();
        }
    }
}

