/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.itemgp;

import au.com.ordermate.sql.SQL;
import au.com.ordermate.sql.queries.SelectQuery;
import ordermate.database.misc.SystemProperty;

public class ItemGPQueries {
    public static final String DB_ITEM_NAME = "inventory_item.Name";
    public static final String DB_ITEM_UNIT_ID = "inventory_item_unit.ID";
    public static final String DB_SIZE_NAME = "inventory_size.Name";
    public static final String DB_PORTION_NAME = "inventory_portion.Name";
    public static final String DB_PRICE_LEVEL_NAME = "inventory_price_level.Name";
    public static final String DB_UNIT_SALES = "inventory_unit_price_level_link.Price";
    public static final String DB_UNIT_SALES_TAX_FORMULA = "inventory_unit_price_level_link.Price * system_tax_code.rate / ( 1 + system_tax_code.rate) ";
    public static final String DB_UNIT_COST = "Cost";
    public static final String DB_GROUP_NAME = "inventory_group.Name";
    public static final String DB_UNIT_GP_PERCENT = "GPPercent";
    public static final String DB_UNIT_GP_VALUE = "GPValue";
    public static final String DB_UNIT_COST_EX = "CostEx";
    public static final String[] dbColumns = new String[]{"inventory_group.Name", "inventory_item.Name", "inventory_size.Name", "inventory_portion.Name", "inventory_price_level.Name", "Cost", "CostEx", "inventory_unit_price_level_link.Price", "GPPercent", "GPValue"};
    public static final String[] displayColumns = new String[]{"Group", "Name", "Size", "Portion", "Price Level", "Est. Cost Inc", "Est. Cost Ex", "Sales", "GP %", "GP"};
    public static final Double DB_TAX_VALUE = new Double(1.0 + SystemProperty.getInstance().getBaseTaxRate());
    public static final String DB_UNIT_COST_FORMULA = "IF (custom_stock_cost IS NULL, IF (stock_inventory_item_unit.ID IS NULL, 0, SUM(stock_inventory_item_unit.Quantity * stock_item.CurrentCost / stock_item.Quantity)), custom_stock_cost * " + DB_TAX_VALUE.toString() + ") ";
    public static final String DB_UNIT_COST_EX_FORMULA = "IF (custom_stock_cost IS NULL, SUM(IF (stock_inventory_item_unit.ID IS NULL, 0, stock_inventory_item_unit.Quantity * stock_item.CurrentCost * if(stock_item.tax_included, 1/" + DB_TAX_VALUE.toString() + ",1) / stock_item.Quantity)), custom_stock_cost)";
    public static final String DISPLAYLABEL_GROUP = "Group";
    public static final int VALUE_INDEX = 4;
    public static final int ID_INDEX = 10;
    public static final int COST_INDEX = 5;
    public static final int COST_EX_INDEX = 6;
    public static final int SALES_INDEX = 7;
    public static final int GP_PERC_INDEX = 8;
    public static final int GP_INDEX = 9;

    public static SelectQuery setupQuery() {
        SelectQuery toSetup = SQL.createQuery(new String[]{" inventory_item_unit JOIN inventory_item ON inventory_item_unit.FK_inventory_item = inventory_item.ID JOIN inventory_group ON inventory_item.FK_inventory_group = inventory_group.ID JOIN inventory_size ON inventory_item_unit.FK_inventory_size = inventory_size.ID JOIN inventory_portion ON inventory_item_unit.FK_inventory_portion = inventory_portion.ID JOIN inventory_unit_price_level_link ON inventory_item_unit.ID = inventory_unit_price_level_link.FK_inventory_item_unit JOIN inventory_price_level ON inventory_unit_price_level_link.FK_inventory_price_level = inventory_price_level.ID INNER JOIN inventory_item_unit_tax ON inventory_item_unit_tax.fk_inventory_item_unit = inventory_item_unit.ID INNER JOIN system_tax_code ON inventory_item_unit_tax.FK_system_tax_code = system_tax_code.ID LEFT JOIN stock_inventory_item_unit ON stock_inventory_item_unit.FK_inventory_item_unit = inventory_item_unit.ID LEFT JOIN stock_item ON stock_inventory_item_unit.FK_stock_item = stock_item.ID AND stock_item.system_state = 'ACTIVE'  "});
        toSetup.addSelectValue(DB_GROUP_NAME);
        toSetup.addSelectValue(DB_ITEM_NAME);
        toSetup.addSelectValue(DB_SIZE_NAME);
        toSetup.addSelectValue(DB_PORTION_NAME);
        toSetup.addSelectValue(DB_PRICE_LEVEL_NAME);
        toSetup.addSelectValue(DB_UNIT_COST_FORMULA + " AS " + DB_UNIT_COST);
        toSetup.addSelectValue(DB_UNIT_COST_EX_FORMULA + " AS " + DB_UNIT_COST_EX);
        toSetup.addSelectValue(DB_UNIT_SALES);
        toSetup.addSelectValue("(inventory_unit_price_level_link.Price - inventory_unit_price_level_link.Price * system_tax_code.rate / ( 1 + system_tax_code.rate) -" + DB_UNIT_COST_EX_FORMULA + ") / (" + DB_UNIT_SALES + " - " + DB_UNIT_SALES_TAX_FORMULA + ") AS " + DB_UNIT_GP_PERCENT);
        toSetup.addSelectValue("inventory_unit_price_level_link.Price - inventory_unit_price_level_link.Price * system_tax_code.rate / ( 1 + system_tax_code.rate)  - " + DB_UNIT_COST_EX_FORMULA + " AS " + DB_UNIT_GP_VALUE);
        toSetup.addSelectValue(DB_ITEM_UNIT_ID);
        toSetup.addGroupBy(DB_ITEM_UNIT_ID);
        toSetup.addGroupBy("inventory_price_level.ID");
        toSetup.addOrderBy(DB_ITEM_NAME, true);
        ItemGPQueries.addWheresToQuery(toSetup);
        return toSetup;
    }

    public static void addWheresToQuery(SelectQuery toSetup) {
        toSetup.clearHaving();
        toSetup.clearWhere();
        toSetup.addWhere(SQL.isActive("inventory_item_unit"));
        toSetup.addWhere(SQL.isActive("inventory_item"));
        toSetup.addWhere(SQL.isActive("inventory_group"));
    }
}

