/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.itemgp;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.ObjectQuerySQLAdapter;
import au.com.ordermate.oquery.search.annotation.FilterConfig;
import au.com.ordermate.oquery.search.filter.implementation.ObjectSearchFilter;
import au.com.ordermate.search.filter.BooleanSearchFilter;
import au.com.ordermate.sql.queries.SelectQuery;
import java.util.Arrays;
import java.util.List;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.reports.itemgp.ItemGPQueries;
import ordermate.database.searchers.ArrayObjectSearcher;

public class ItemGPSearcher
extends ArrayObjectSearcher {
    private BooleanSearchFilter groupedFilter = new BooleanSearchFilter(null);
    private ObjectSearchFilter<InventoryGroup> groupFilter = new ObjectSearchFilter(null);
    private ObjectSearchFilter<InventoryProfile> profileFilter = new ObjectSearchFilter(null);

    @Override
    protected ObjectQuery createBaseQuery() {
        SelectQuery query = this.getSelectQuery();
        ObjectQuerySQLAdapter adapter = new ObjectQuerySQLAdapter(query.getSQL());
        return adapter;
    }

    public SelectQuery getSelectQuery() {
        SelectQuery query = ItemGPQueries.setupQuery();
        ItemGPQueries.addWheresToQuery(query);
        if (this.profileFilter.hasSearchValue()) {
            query.addWhere("inventory_group.FK_inventory_profile = " + ((InventoryProfile)this.profileFilter.getSearchValue()).getID());
        }
        if (this.groupFilter.hasSearchValue()) {
            InventoryGroup group = (InventoryGroup)this.groupFilter.getSearchValue();
            List<InventoryGroup> allChildren = group.getRecursiveSubGroups();
            String[] conditions = new String[allChildren.size() + 1];
            conditions[0] = "inventory_group.ID = " + group.getID();
            for (int i = 0; i < allChildren.size(); ++i) {
                InventoryGroup child = allChildren.get(i);
                conditions[i + 1] = "inventory_group.ID = " + child.getID();
            }
            query.addWhereOr(conditions);
        }
        if (Boolean.TRUE.equals(this.groupedFilter.getSearchValue())) {
            query.clearOrderBy();
            query.addOrderBy("inventory_group.Name");
            query.addOrderBy("inventory_item.Name");
        }
        return query;
    }

    @Override
    protected List<String> createStaticColumns() {
        return Arrays.asList("inventory_group.Name", "inventory_item.Name", "inventory_size.Name", "inventory_portion.Name", "inventory_price_level.Name", "Cost", "CostEx", "inventory_unit_price_level_link.Price", "GPPercent", "GPValue");
    }

    @FilterConfig(name="Grouped", dataType=Boolean.class, plural=FilterConfig.Plural.Single, priority=true, sequence=1)
    public BooleanSearchFilter getGroupedFilter() {
        return this.groupedFilter;
    }

    @FilterConfig(name="Section", dataType=InventoryGroup.class, plural=FilterConfig.Plural.Single, priority=true, sequence=2)
    public ObjectSearchFilter<InventoryGroup> getGroupFilter() {
        return this.groupFilter;
    }

    @FilterConfig(name="Profile", defaultValue="1", dataType=InventoryProfile.class, plural=FilterConfig.Plural.Single, nullAllowed=false, priority=true, sequence=3)
    public ObjectSearchFilter<InventoryProfile> getProfileFilter() {
        return this.profileFilter;
    }
}

