/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.itemsold;

import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import ordermate.database.reports.sales.general.itemsold.ItemSoldReport;
import ordermate.database.reports.sales.general.itemsold.ItemSoldSummaryReport;
import ordermate.database.searchers.reports.sales.general.itemsold.ItemSoldReportCompiler;
import ordermate.reports.impl.ListDataSourceProvider;

public class ItemSoldSummaryDataProvider
extends ListDataSourceProvider {
    private ItemSoldReportCompiler compiler;

    public ItemSoldSummaryDataProvider(ItemSoldReportCompiler theCompiler) {
        this.compiler = theCompiler;
    }

    private Map<String, ItemSoldSummaryReport> coalesceReports(List<ItemSoldReport> reports) {
        HashMap<String, ItemSoldSummaryReport> map = new HashMap<String, ItemSoldSummaryReport>();
        double total = 0.0;
        for (ItemSoldReport report : reports) {
            String groupName = report.getInventoryGroupName();
            ItemSoldSummaryReport summary = !map.containsKey(groupName) ? new ItemSoldSummaryReport(groupName) : (ItemSoldSummaryReport)map.get(groupName);
            summary.addItemSoldReport(report);
            total += report.getSalesValueRaw().doubleValue();
            map.put(groupName, summary);
        }
        Price totalSales = new Price(total, 1.0E-5);
        Iterator it = map.values().iterator();
        while (it.hasNext()) {
            ((ItemSoldSummaryReport)it.next()).setTotalSales(totalSales);
        }
        return map;
    }

    @Override
    protected List getDataList() {
        List<ItemSoldReport> reports = this.compiler.compile();
        if (reports.isEmpty()) {
            return new ArrayList();
        }
        Map<String, ItemSoldSummaryReport> map = this.coalesceReports(reports);
        ArrayList<ItemSoldSummaryReport> summaries = new ArrayList<ItemSoldSummaryReport>(map.values());
        return summaries;
    }
}

