/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.itemsold;

import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.builders.BuilderException;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.search.IRangedSearchFilter;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import ordermate.database.reports.ReportProviderHelper;
import ordermate.database.reports.itemsold.ItemSoldSummaryDataProvider;
import ordermate.database.reports.sales.general.itemsold.ItemSoldHelper;
import ordermate.database.reports.sales.general.itemsold.ItemSoldReport;
import ordermate.database.reports.sales.general.itemsold.ItemSoldSummaryReport;
import ordermate.database.sales.itemfilter.TimeSearchFilter;
import ordermate.database.searchers.reports.TradingDayFilteredReportSearcher;
import ordermate.database.searchers.reports.sales.general.itemsold.ItemSoldReportCompiler;
import ordermate.database.searchers.reports.sales.general.itemsold.ItemSoldReportSearcher;
import ordermate.database.users.User;
import ordermate.internationalization.Internationalization;
import ordermate.reports.dynamicjasper.PeriodReportAdapter;
import ordermate.reports.dynamicjasper.ReportBuilder;
import ordermate.reports.dynamicjasper.reportbuilder.AbstractReportProvider;
import ordermate.reports.dynamicjasper.reportbuilder.DataSourceProvider;

public class ItemSoldSummaryReportProvider
extends AbstractReportProvider {
    private final DataSourceProvider provider;
    private final ItemSoldReportCompiler compiler;
    private PeriodReportAdapter period;
    private User user;
    private boolean showCOGS = false;

    public ItemSoldSummaryReportProvider(ItemSoldReportCompiler reportCompiler) {
        this(reportCompiler, null);
    }

    public ItemSoldSummaryReportProvider(ItemSoldReportCompiler reportCompiler, PeriodReportAdapter period) {
        this.compiler = reportCompiler;
        this.period = period;
        this.provider = new ItemSoldSummaryDataProvider(reportCompiler);
    }

    @Override
    public synchronized ReportBuilder getBuilder() throws BuilderException {
        ReportBuilder builder = this.initBuilder();
        builder.setSubtitle(this.makeSubTitle());
        if (this.showCOGS) {
            builder.addReportColumn(ItemSoldSummaryReport.Properties.TOTAL_COGS, "COGS", Internationalization.getLiteralFor("PRICE_PATTERN"));
            builder.addReportColumn(ItemSoldSummaryReport.Properties.TOTAL_COGS_PERCENTAGE, "COGS %", "0.0%");
            builder.getReportBuilder().addGlobalFooterVariable((AbstractColumn)builder.getPropertyColumn(ItemSoldSummaryReport.Properties.TOTAL_COGS), DJCalculation.SUM);
        }
        return builder;
    }

    private String makeSubTitle() {
        String subtitle = this.getDisplayableDate() + " - ";
        TimeSearchFilter timeFilter = this.compiler.getSearcher().getSalesTimeRangeFilter();
        return subtitle + timeFilter.getDisplayableTime();
    }

    public String getDisplayableDate() {
        IRangedSearchFilter dateRangeFilter = this.compiler.getSearcher().getTradingDayDateRangeFilter();
        IRangedQuerySearchFilter<Date> dateRangeAdapter = this.compiler.getSearcher().getTradingDayDateRangeAdapter();
        if (this.period != null && dateRangeFilter.hasSearchValue()) {
            return this.period.formatTradingDayRangeForDisplay((Date)dateRangeFilter.getStart(), (Date)dateRangeFilter.getEnd(), (Date)dateRangeAdapter.getEnd());
        }
        return TradingDayFilteredReportSearcher.DisplayHelper.getDisplayableDate(this.compiler.getSearcher());
    }

    @Override
    public DynamicReport getReport() throws BuilderException {
        DynamicReport report = this.getBuilder().buildJasperReport();
        report.setTitle(this.generateTitle());
        report.setSubtitle(this.generateSubtitle());
        List<ItemSoldReport> results = this.compiler.getLastSearchResults();
        if (results != null && results.size() != 0) {
            this.setParams(results);
        }
        return report;
    }

    private void setParams(List<ItemSoldReport> results) {
        Map<String, Object> map = super.getParameters();
        ItemSoldHelper.addCategoryTotalsParams(map, results);
        ItemSoldHelper.addSalesTotalsParams(map, results);
    }

    @Override
    public JRRewindableDataSource getDataSource() {
        List<ItemSoldReport> results = this.compiler.compile();
        this.setParams(results);
        return this.provider.getDataSource();
    }

    private synchronized ReportBuilder initBuilder() throws BuilderException {
        ReportBuilder builder = new ReportBuilder();
        this.getParameters().putAll(builder.addBusinessLogoDetailHeaderAndFooterTemplate());
        if (this.user != null) {
            this.addParam("user", this.user.getName());
        }
        builder.setTitle("Menu Sections Totals");
        builder.addReportColumns(Arrays.asList(ItemSoldSummaryReport.Properties.DUMMY_GROUP, ItemSoldSummaryReport.Properties.INVENTORY_GROUP_NAME), "", "Menu Section");
        builder.addReportColumn(ItemSoldSummaryReport.Properties.QUANTITY_SOLD, "# Sales", "0");
        builder.addReportColumn(ItemSoldSummaryReport.Properties.SALES_VALUE, "Sales", Internationalization.getLiteralFor("PRICE_PATTERN"));
        builder.addReportColumn(ItemSoldSummaryReport.Properties.PERC_OF_SALES, "% of Sales", "0.0%");
        builder.addGroupBy(ItemSoldSummaryReport.Properties.DUMMY_GROUP, null).getColumnToGroupBy().setWidth(Integer.valueOf(0));
        builder.getReportBuilder().setGrandTotalLegend("Total");
        builder.getReportBuilder().addGlobalFooterVariable((AbstractColumn)builder.getPropertyColumn(ItemSoldSummaryReport.Properties.QUANTITY_SOLD), DJCalculation.SUM);
        builder.getReportBuilder().addGlobalFooterVariable((AbstractColumn)builder.getPropertyColumn(ItemSoldSummaryReport.Properties.SALES_VALUE), DJCalculation.SUM);
        ItemSoldHelper.addCategoryTotalsReport(builder, true);
        ItemSoldHelper.addSalesTotalReport(builder);
        return builder;
    }

    private String generateTitle() {
        return (this.period == null ? "" : this.period.getLabel() + " ") + "Menu Sections Totals";
    }

    private String generateSubtitle() {
        ItemSoldReportSearcher searcher = this.compiler.getSearcher();
        StringBuilder SB = new StringBuilder(this.getDisplayableDate());
        TimeSearchFilter timeFilter = searcher.getSalesTimeRangeFilter();
        String timeString = timeFilter.getDisplayableTime();
        this.getHelper().appendSubTitleAndValue(SB, "Day Part", timeString);
        this.getHelper().appendSearchFilter(SB, "Users", searcher.getUserFilter());
        this.getHelper().appendSearchFilter(SB, "Account Type", searcher.getAccountTypeFilter());
        this.getHelper().appendSearchFilter(SB, "Menu Section", searcher.getMenuSectionFilter());
        this.getHelper().appendSearchFilter(SB, "Category", searcher.getCategoryFilter());
        this.getHelper().appendSearchFilter(SB, "Shift", searcher.getShiftFilter());
        this.getHelper().appendSearchFilter(SB, "Customer Category", searcher.getCustomerCategoryFilter());
        this.getHelper().appendSearchFilter(SB, "Customer Group", searcher.getCustomerGroupFilter());
        this.getHelper().appendSearchFilter(SB, "Terminals", searcher.getTerminalFilter());
        this.getHelper().appendSearchFilter(SB, "Sales Locations", searcher.getSalesLocationFilter());
        this.getHelper().appendSearchFilter(SB, "Price Level", searcher.getPriceLevelFilter());
        this.getHelper().appendSearchFilter(SB, "Size", searcher.getSizeFilter());
        this.getHelper().appendSearchFilter(SB, "Text Search", searcher.getItemNameFilter());
        return SB.toString();
    }

    public void setUser(User aUser) {
        this.user = aUser;
    }

    public User getUser() {
        return this.user;
    }

    @Override
    protected String getAdditionalFooterText() {
        return "Sales in this report are being filtered based on " + ReportProviderHelper.describeRangeFilter(this.compiler.getSearcher().getTradingDayDateRangeFilter()) + System.getProperty("line.separator") + "Prices include discounts & surcharges that may not have been applied within the selected period.";
    }

    public void setShowCOGS(boolean showCOGS) {
        this.showCOGS = showCOGS;
    }
}

