/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.keycategory;

import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.builders.BuilderException;
import ar.com.fdvs.dj.domain.builders.ColumnBuilderException;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import au.com.ordermate.persistence.PropertiedObject;
import java.util.ArrayList;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import ordermate.database.reports.CategorySalesReport;
import ordermate.database.searchers.reports.CategoryReportSearcher;
import ordermate.internationalization.Internationalization;
import ordermate.reports.dynamicjasper.ReportBuilder;
import ordermate.reports.dynamicjasper.reportbuilder.AbstractReportProvider;
import ordermate.reports.impl.SearcherDataSourceProvider;

public class CategoryReportProvider
extends AbstractReportProvider {
    private ReportBuilder builder;
    private DynamicReport report;
    private final CategoryReportSearcher searcher;
    private final SearcherDataSourceProvider<CategoryReportSearcher> dataSourceProvider;

    public CategoryReportProvider(CategoryReportSearcher newSearcher) throws ColumnBuilderException {
        this.searcher = newSearcher;
        this.dataSourceProvider = new SearcherDataSourceProvider<CategoryReportSearcher>(this.searcher);
        this.initBuilder();
    }

    private void initBuilder() throws ColumnBuilderException {
        this.builder = new ReportBuilder();
        this.builder.setTitle("Key Category Report");
        this.builder.addReportColumns(new ArrayList<PropertiedObject.Property>(){
            {
                this.add(CategorySalesReport.Properties.INVENTORY_CATEGORY_NAME);
                this.add(CategorySalesReport.Properties.QUANTITY_SOLD);
                this.add(CategorySalesReport.Properties.SALES_VALUE);
                this.add(CategorySalesReport.Properties.PERC_OF_SALES_STR);
            }
        }, "Category", "Quantity Sold", "Sales Value", "% of Total Sales");
        this.builder.getPropertyColumn(CategorySalesReport.Properties.QUANTITY_SOLD).setPattern("0");
        this.builder.getPropertyColumn(CategorySalesReport.Properties.SALES_VALUE).setPattern(Internationalization.getLiteralFor("DOLLAR_SIGN") + "0.00");
        this.builder.getReportBuilder().setGrandTotalLegend("Total");
        this.builder.getReportBuilder().addGlobalFooterVariable((AbstractColumn)this.builder.getPropertyColumn(CategorySalesReport.Properties.QUANTITY_SOLD), DJCalculation.SUM);
        this.builder.getReportBuilder().addGlobalFooterVariable((AbstractColumn)this.builder.getPropertyColumn(CategorySalesReport.Properties.SALES_VALUE), DJCalculation.SUM);
        this.getParameters().putAll(this.builder.addBusinessLogoDetailHeaderAndFooterTemplate());
    }

    @Override
    public ReportBuilder getBuilder() throws BuilderException {
        if (this.builder == null) {
            this.initBuilder();
        }
        return this.builder;
    }

    @Override
    protected DynamicReport getReport() throws BuilderException {
        if (this.report == null) {
            this.report = this.builder.buildJasperReport();
        }
        StringBuilder SB = new StringBuilder(this.searcher.getDisplayableDate());
        this.getHelper().appendSearchFilter(SB, "Category", this.searcher.getCategoryNameFilter());
        this.report.setSubtitle(SB.toString());
        return this.report;
    }

    @Override
    public JRRewindableDataSource getDataSource() {
        return this.dataSourceProvider.getDataSource();
    }

    @Override
    protected String getAdditionalFooterText() {
        return null;
    }
}

