/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.kts;

import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentSummaryObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import ordermate.database.sales.Account;

@Entity
public class KTSReport
extends PersistentSummaryObject {
    public static final Props Properties = new Props();
    private Date dateTime;
    private String KTSName;
    private Reference<Account> account;
    private int time;

    public KTSReport() {
        this.account = this.createReference(KTSReport.Properties.ACCOUNT);
    }

    @Column(name="date_time")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getDateTime() {
        return this.dateTime;
    }

    @Column(name="kts_name")
    public String getKTSName() {
        return this.KTSName;
    }

    @Transient
    public BigDecimal getAccountNumber() {
        if (this.getAccount() == null) {
            return null;
        }
        return new BigDecimal(this.getAccount().intID());
    }

    @Transient
    public String getAccountDescription() {
        if (this.getAccount() == null) {
            return null;
        }
        return this.getAccount().getDescription();
    }

    @Column(name="time")
    public int getTime() {
        return this.time;
    }

    @ManyToOne
    @JoinColumn(name="fk_config_user")
    public Account getAccount() {
        return this.account.get();
    }

    @Transient
    public Integer getTimeInt() {
        return this.time;
    }

    public void setDateTime(Date value) {
        this.dateTime = value;
    }

    public void setKTSName(String value) {
        this.KTSName = value;
    }

    public void setTime(int value) {
        this.time = value;
    }

    public void setAccount(Account value) {
        this.account.set(value);
    }

    @Override
    public String toString() {
        return this.KTSName + " " + this.dateTime + " " + this.time;
    }

    public static class Props
    extends PersistentSummaryObject.Props {
        public PropertiedObject.Property<Date> DATE_TIME;
        public PropertiedObject.Property<String> KTS_NAME;
        public PropertiedObject.Property<Account> ACCOUNT;
        public PersistentObject.DerivedProperty<BigDecimal> ACCOUNT_NUMBER = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)KTSReport.class), "accountNumber");
        public PersistentObject.DerivedProperty<String> ACCOUNT_DESCRIPTION = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)KTSReport.class), "accountDescription");
        public PropertiedObject.Property TIME;
        public PersistentObject.DerivedProperty<Integer> TIME_INT = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)KTSReport.class), "timeInt");
    }
}

