/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.kts;

import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.util.DateTimeUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import ordermate.database.reports.kts.KTSReportCompiler;
import ordermate.reports.dynamicjasper.PeriodReportAdapter;

public class KTSReportChartTableModel
extends AbstractTableModel {
    KTSReportCompiler compiler;

    public KTSReportChartTableModel(KTSReportCompiler comp) {
        this.compiler = comp;
    }

    @Override
    public int getRowCount() {
        return this.getPeriodList().size();
    }

    @Override
    public int getColumnCount() {
        return this.compiler.getKTSNames().size() + 1;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        List<String> periodList = this.getPeriodList();
        if (columnIndex == 0) {
            return periodList.get(rowIndex);
        }
        return this.compiler.getReport(this.compiler.getKTSNames().get(columnIndex - 1), this.getPeriodList().get(rowIndex)).getAvgTime().doubleValue() / 60000.0;
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return "period";
        }
        return this.compiler.getKTSNames().get(column - 1);
    }

    private List<String> getPeriodList() {
        PeriodReportAdapter period = this.compiler.getSearcher().getPeriod();
        IRangedQuerySearchFilter<Date> dateFilter = this.compiler.getSearcher().getDateRangeFilter();
        ArrayList<String> periodStringList = new ArrayList<String>();
        Date tempStart = (Date)dateFilter.getStart();
        Date tempEnd = (Date)dateFilter.getEnd();
        if (tempEnd.before(tempStart)) {
            Date swapper = tempStart;
            tempStart = tempEnd;
            tempEnd = swapper;
        }
        if (period == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(DateTimeUtils.getShortDateFormat().format(tempStart));
            sb.append(" - ");
            sb.append(DateTimeUtils.getShortDateFormat().format(tempStart));
            periodStringList.add(sb.toString());
            return periodStringList;
        }
        List<Date> dateList = period.getDateList();
        Collections.sort(dateList, new Comparator<Date>(){

            @Override
            public int compare(Date o1, Date o2) {
                return o1.compareTo(o2);
            }
        });
        for (Date d : dateList) {
            if (tempStart.compareTo(d) > 0 || tempEnd.compareTo(d) < 0) continue;
            periodStringList.add(period.formatDateForDisplay(d));
        }
        return periodStringList;
    }
}

