/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.kts;

import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.util.DateTimeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ordermate.database.reports.kts.KTSReport;
import ordermate.database.reports.kts.KTSReportSummary;
import ordermate.database.searchers.reports.KTSReportSearcher;
import ordermate.reports.dynamicjasper.PeriodReportAdapter;

public class KTSReportCompiler {
    private KTSReportSearcher searcher;
    private Map<String, Map<String, KTSReportSummary>> cachedResults;
    private List<String> ktsNames;

    public KTSReportCompiler(KTSReportSearcher searcher) {
        this.searcher = searcher;
        this.cachedResults = new HashMap<String, Map<String, KTSReportSummary>>();
        this.ktsNames = new ArrayList<String>();
    }

    public List<KTSReportSummary> compileResults() {
        this.cachedResults.clear();
        this.ktsNames.clear();
        ArrayList<KTSReportSummary> resultsList = new ArrayList<KTSReportSummary>();
        PeriodReportAdapter period = this.searcher.getPeriod();
        IRangedQuerySearchFilter<Date> dateFilter = this.searcher.getDateRangeFilter();
        for (KTSReport weekdaySales : this.searcher.search()) {
            String name = weekdaySales.getKTSName();
            String periodField = this.getPeriodFieldName(period, weekdaySales.getDateTime(), dateFilter);
            if (this.cachedResults.get(name) != null) {
                if (this.cachedResults.get(name).get(periodField) != null) {
                    this.cachedResults.get(name).get(periodField).addTime(weekdaySales.getTime());
                    continue;
                }
                this.cachedResults.get(name).put(periodField, new KTSReportSummary(name, periodField));
                this.cachedResults.get(name).get(periodField).addTime(weekdaySales.getTime());
                continue;
            }
            HashMap<String, KTSReportSummary> periodBucket = new HashMap<String, KTSReportSummary>();
            periodBucket.put(periodField, new KTSReportSummary(name, periodField));
            this.cachedResults.put(name, periodBucket);
            this.cachedResults.get(name).get(periodField).addTime(weekdaySales.getTime());
            this.ktsNames.add(name);
        }
        for (String x : this.ktsNames) {
            resultsList.addAll(this.cachedResults.get(x).values());
        }
        return resultsList;
    }

    public String getPeriodFieldName(PeriodReportAdapter period, Date dateTime, IRangedQuerySearchFilter<Date> dateFilter) {
        if (period != null) {
            return period.formatDateForDisplay(dateTime);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(DateTimeUtils.getShortDateFormat().format((Date)dateFilter.getStart()));
        sb.append(" - ");
        sb.append(DateTimeUtils.getShortDateFormat().format((Date)dateFilter.getEnd()));
        return sb.toString();
    }

    public KTSReportSearcher getSearcher() {
        return this.searcher;
    }

    public List<KTSReportSummary> getResults() {
        List<KTSReportSummary> newResults = new ArrayList<KTSReportSummary>();
        newResults = this.addEmptyKTSReports(newResults);
        return newResults;
    }

    protected List<KTSReportSummary> addEmptyKTSReports(List<KTSReportSummary> newResults) {
        PeriodReportAdapter period = this.searcher.getPeriod();
        ArrayList<String> periodStringList = new ArrayList<String>();
        IRangedQuerySearchFilter<Date> dateFilter = this.searcher.getDateRangeFilter();
        if (period == null) {
            periodStringList.add(this.getPeriodFieldName(period, null, this.searcher.getDateRangeFilter()));
        } else {
            Date tempStart = (Date)dateFilter.getStart();
            Date tempEnd = (Date)dateFilter.getEnd();
            if (tempEnd.before(tempStart)) {
                Date swapper = tempStart;
                tempStart = tempEnd;
                tempEnd = swapper;
            }
            List<Date> dateList = period.getDateList();
            for (Date d : dateList) {
                if (tempStart.compareTo(d) > 0 || tempEnd.compareTo(d) < 0) continue;
                periodStringList.add(period.formatDateForDisplay(d));
            }
        }
        for (String ktsName : this.ktsNames) {
            for (String timePeriod : periodStringList) {
                KTSReportSummary ktsSummary = this.cachedResults.get(ktsName).get(timePeriod);
                if (ktsSummary == null) {
                    ktsSummary = new KTSReportSummary(ktsName, timePeriod);
                }
                newResults.add(ktsSummary);
            }
        }
        return newResults;
    }

    public KTSReportSummary getReport(String ktsName, String timePeriod) {
        KTSReportSummary ktsSummary = this.cachedResults.get(ktsName).get(timePeriod);
        if (ktsSummary == null) {
            ktsSummary = new KTSReportSummary(ktsName, timePeriod);
        }
        return ktsSummary;
    }

    private String format(Integer obj) {
        StringBuffer toAppendTo = new StringBuffer();
        int time = obj / 1000;
        int minutes = time / 60;
        if (minutes < 10) {
            toAppendTo.append("0");
        }
        toAppendTo.append(minutes);
        toAppendTo.append(":");
        int seconds = time % 60;
        if (seconds < 10) {
            toAppendTo.append("0");
        }
        toAppendTo.append(seconds);
        return toAppendTo.toString();
    }

    public List<String> getKTSReportDisplayableColumnNames() {
        List<String> newList = Arrays.asList("KTS Name", "Period", "Max Time", "Min Time", "Avg Time");
        return newList;
    }

    public List<String> getKTSNames() {
        return this.ktsNames;
    }
}

