/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.kts;

import ar.com.fdvs.dj.core.layout.ClassicLayoutManager;
import ar.com.fdvs.dj.core.layout.LayoutManager;
import ar.com.fdvs.dj.domain.ColumnProperty;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.BuilderException;
import ar.com.fdvs.dj.domain.builders.ChartBuilderException;
import ar.com.fdvs.dj.domain.builders.ColumnBuilderException;
import ar.com.fdvs.dj.domain.chart.DJChart;
import ar.com.fdvs.dj.domain.chart.builder.DJLineChartBuilder;
import ar.com.fdvs.dj.domain.chart.plot.DJAxisFormat;
import ar.com.fdvs.dj.domain.constants.GroupLayout;
import ar.com.fdvs.dj.domain.entities.DJGroup;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.columns.PropertyColumn;
import ar.com.fdvs.dj.domain.entities.columns.SimpleColumn;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import ordermate.OrderMate;
import ordermate.database.reports.kts.KTSReportChartTableModel;
import ordermate.database.reports.kts.KTSReportCompiler;
import ordermate.database.reports.kts.KTSReportSummary;
import ordermate.database.searchers.reports.KTSReportSearcher;
import ordermate.database.searchers.reports.TradingDayFilteredReportSearcher;
import ordermate.reports.dynamicjasper.OrderMateOmorphosReportStyle;
import ordermate.reports.dynamicjasper.PeriodReportAdapter;
import ordermate.reports.dynamicjasper.ReportBuilder;
import ordermate.reports.dynamicjasper.customexpressions.TimerExpressionBuilder;
import ordermate.reports.dynamicjasper.reportbuilder.AbstractReportProvider;
import ordermate.reports.impl.SearcherDataSourceProvider;

public class KTSReportProvider
extends AbstractReportProvider {
    private SearcherDataSourceProvider searcherDataSourceProvider;
    private KTSReportCompiler compiler;
    private static final String KTS_DATA_COLUMNS = "KTS Report";
    private static final String MINUTES_SECONDS_FORMAT = "#:00";
    private static final String KTS_CHART_DATA = "KTS_CHART_DATA";

    public KTSReportProvider(KTSReportSearcher searcher) {
        this.searcherDataSourceProvider = new SearcherDataSourceProvider<KTSReportSearcher>(searcher);
        this.compiler = new KTSReportCompiler(searcher);
    }

    @Override
    public JRRewindableDataSource getDataSource() {
        return new JRBeanCollectionDataSource(this.compiler.getResults());
    }

    @Override
    protected DynamicReport getReport() throws BuilderException {
        this.compiler.compileResults();
        this.addParam(KTS_CHART_DATA, new JRTableModelDataSource((TableModel)new KTSReportChartTableModel(this.compiler)));
        List<KTSReportSummary> sumList = this.compiler.getResults();
        Collections.reverse(sumList);
        this.addParam(KTS_DATA_COLUMNS, new JRBeanCollectionDataSource(sumList));
        return this.getBuilder().buildJasperReport();
    }

    @Override
    public ReportBuilder getBuilder() throws BuilderException {
        this.compiler.compileResults();
        ReportBuilder builder = new ReportBuilder(new OrderMateOmorphosReportStyle());
        this.getParameters().putAll(builder.addBusinessLogoDetailHeaderAndFooterTemplate());
        builder.setTitle("KTS Transactions Performed");
        KTSReportSearcher reportSearcher = (KTSReportSearcher)this.searcherDataSourceProvider.getSearch();
        IRangedQuerySearchFilter<Date> dateFilter = reportSearcher.getDateRangeFilter();
        IRangedQuerySearchFilter<Date> dateAdapter = reportSearcher.getTradingDayDateRangeAdapter();
        PeriodReportAdapter period = reportSearcher.getPeriod();
        StringBuilder subTitle = new StringBuilder();
        if (period == null) {
            subTitle.append(TradingDayFilteredReportSearcher.DisplayHelper.getDisplayableDate(dateAdapter));
        } else {
            subTitle.append(period.formatTradingDayRangeForDisplay((Date)dateFilter.getStart(), (Date)dateFilter.getEnd(), (Date)dateAdapter.getEnd()));
        }
        String timeString = reportSearcher.getTimeFilter().getDisplayableTime();
        if (!timeString.isEmpty()) {
            this.getHelper().appendSubTitleAndValue(subTitle, "Day Part", timeString);
        }
        this.getHelper().appendSearchFilter(subTitle, "KTS", reportSearcher.getKTSSearchFilter());
        this.getHelper().appendSearchFilter(subTitle, "Sales Location", reportSearcher.getSalesLocationFilter());
        builder.setSubtitle(subTitle.toString());
        try {
            builder.getReportBuilder().addConcatenatedReport(this.generateChartSubReport(), (LayoutManager)new ClassicLayoutManager(), KTS_CHART_DATA, 0, 10, false);
        }
        catch (Exception ex) {
            OrderMate.LOG.warn("Cannot build kts chart report", (Throwable)ex);
        }
        try {
            builder.getReportBuilder().addConcatenatedReport(this.generateKTSSummaryReport(), (LayoutManager)new ClassicLayoutManager(), KTS_DATA_COLUMNS, 0, 10, false);
        }
        catch (Exception ex) {
            OrderMate.LOG.warn("Cannot build kts summary report", (Throwable)ex);
        }
        builder.getReportBuilder().setAllowDetailSplit(true);
        return builder;
    }

    private DynamicReport generateKTSSummaryReport() throws ColumnBuilderException {
        ReportBuilder dataSubReportBuilder = new ReportBuilder();
        dataSubReportBuilder.getCustomExpressionRegister().put(Integer.class, new TimerExpressionBuilder());
        Object[] colNames = this.compiler.getKTSReportDisplayableColumnNames().toArray();
        dataSubReportBuilder.addReportColumn(KTSReportSummary.Properties.KTS_NAME, String.valueOf(colNames[0]), null);
        dataSubReportBuilder.addReportColumn(KTSReportSummary.Properties.PERIOD, String.valueOf(colNames[1]), null);
        dataSubReportBuilder.addReportColumn(KTSReportSummary.Properties.MAX_TIME, String.valueOf(colNames[2]), MINUTES_SECONDS_FORMAT);
        dataSubReportBuilder.addReportColumn(KTSReportSummary.Properties.MIN_TIME, String.valueOf(colNames[3]), MINUTES_SECONDS_FORMAT);
        dataSubReportBuilder.addReportColumn(KTSReportSummary.Properties.AVG_TIME, String.valueOf(colNames[4]), MINUTES_SECONDS_FORMAT);
        DJGroup group = dataSubReportBuilder.addGroupBy(KTSReportSummary.Properties.KTS_NAME, new ArrayList<ReportBuilder.PropertyCalculation>());
        group.setLayout(GroupLayout.VALUE_IN_HEADER_WITH_HEADERS_AND_COLUMN_NAME);
        group.setReprintHeaderOnEachPage(Boolean.TRUE);
        group.setAllowHeaederSplit(false);
        group.setAllowFooterSplit(false);
        group.setHeaderHeight(Integer.valueOf(15));
        Style groupedColumnStyle = dataSubReportBuilder.getStyles().getGroupedDetailStyle();
        PropertyColumn groupCol = dataSubReportBuilder.getPropertyColumn(KTSReportSummary.Properties.KTS_NAME);
        groupCol.setHeaderStyle(groupedColumnStyle);
        groupCol.setStyle(groupedColumnStyle);
        dataSubReportBuilder.getReportBuilder().setAllowDetailSplit(true);
        return dataSubReportBuilder.buildJasperReport();
    }

    private DynamicReport generateChartSubReport() throws ChartBuilderException {
        ReportBuilder builder = new ReportBuilder();
        builder.addInvisibleField("period", String.class);
        for (String string : this.compiler.getKTSNames()) {
            builder.addInvisibleField(string, Number.class);
        }
        DJLineChartBuilder chartBuilder = new DJLineChartBuilder().setValueAxisFormat(new DJAxisFormat("Average Time"));
        for (String name : this.compiler.getKTSNames()) {
            ColumnProperty prop = new ColumnProperty(name, Number.class);
            SimpleColumn column = new SimpleColumn();
            column.setColumnProperty(prop);
            column.setName(name);
            column.setTitle(name);
            chartBuilder.addSerie((AbstractColumn)column);
        }
        ColumnProperty columnProperty = new ColumnProperty("period", String.class);
        SimpleColumn column = new SimpleColumn();
        column.setColumnProperty(columnProperty);
        column.setName("period");
        column.setTitle("period");
        try {
            DJChart chart = chartBuilder.setColumnGroup((PropertyColumn)column).setPosition((byte)1).build();
            chart.getPlot().setLabelRotation(ReportBuilder.BAR_LABEL_ROTATION);
            builder.addChart(chart);
        }
        catch (Exception ex) {
            OrderMate.LOG.warn("Couldn't apply chart to kts report", (Throwable)ex);
        }
        return builder.buildJasperReport();
    }

    @Override
    protected String getAdditionalFooterText() {
        return null;
    }
}

