/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.kts;

import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;

public class KTSReportSummary
implements PropertiedObject {
    public static final Props Properties = new Props();
    private String KTSName;
    private String period;
    private Integer totalTime;
    private Integer numTimes;
    private Integer minTime;
    private Integer maxTime;

    public KTSReportSummary() {
    }

    public KTSReportSummary(String newKTS, String newPeriod) {
        this.KTSName = newKTS;
        this.period = newPeriod;
        this.minTime = Integer.MAX_VALUE;
        this.maxTime = 0;
        this.totalTime = 0;
        this.numTimes = 0;
    }

    public void addTime(int time) {
        this.totalTime = this.totalTime + time;
        Integer n = this.numTimes;
        Integer n2 = this.numTimes = Integer.valueOf(this.numTimes + 1);
        if (time < this.minTime) {
            this.minTime = time;
        }
        if (time > this.maxTime) {
            this.maxTime = time;
        }
    }

    public String getKTSName() {
        return this.KTSName;
    }

    public final String getPeriod() {
        return this.period;
    }

    public final Integer getMinTime() {
        if (this.minTime == Integer.MAX_VALUE) {
            return 0;
        }
        return this.minTime;
    }

    public final Integer getMaxTime() {
        return this.maxTime;
    }

    public final Integer getAvgTime() {
        if (this.numTimes == 0) {
            return 0;
        }
        return this.totalTime / this.numTimes;
    }

    @Override
    public Props getProperties() {
        return Properties;
    }

    @Override
    public <T> T getPropertyValue(PropertiedObject.Property<T> prop) {
        return PropertiedObject.PropsHelper.getPropertyValue(this, prop);
    }

    public void setKTSName(String ktsName) {
        this.KTSName = ktsName;
    }

    public void setPeriod(String period) {
        this.period = period;
    }

    public static class Props
    extends PropertiedObject.Props {
        public PropertiedObject.Property<String> KTS_NAME;
        public PropertiedObject.Property<String> PERIOD;
        public PropertiedObject.Property<Integer> MIN_TIME;
        public PropertiedObject.Property<Integer> MAX_TIME;
        public PersistentObject.DerivedProperty<Integer> AVG_TIME = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)KTSReportSummary.class), "avgTime");
    }
}

