/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.maker;

import ar.com.fdvs.dj.domain.DJDataSource;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.builders.BuilderException;
import ar.com.fdvs.dj.domain.entities.Subreport;
import au.com.ordermate.oquery.search.annotation.FilterConfig;
import au.com.ordermate.oquery.search.control.SearchFilterControl;
import au.com.ordermate.oquery.search.control.SearchFilterControlFactory;
import au.com.ordermate.reports.MakesReport;
import au.com.ordermate.reports.ReportMaker;
import au.com.ordermate.reports.ReportOutput;
import au.com.ordermate.search.SearchFilterI;
import au.com.ordermate.util.Pair;
import au.com.ordermate.util.StringUtils;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import ordermate.OrderMate;
import ordermate.database.config.report.ReportConfig;
import ordermate.database.config.report.ReportConfigFilter;
import ordermate.database.config.report.ReportProperty;
import ordermate.database.reports.config.custom.CustomReportBuilder;
import ordermate.database.reports.config.custom.CustomReportProvider;
import ordermate.database.reports.maker.ReportMakerSearchControls;
import ordermate.database.reports.maker.ReportMakerUtility;
import ordermate.reports.dynamicjasper.ReportBuilder;
import ordermate.reports.dynamicjasper.reportbuilder.AbstractReportProvider;
import ordermate.reports.dynamicjasper.reportbuilder.DataSourceProvider;
import ordermate.reports.dynamicjasper.reportbuilder.ReportProvider;
import ordermate.reports.impl.OrdermateReportTemplateProvider;

public abstract class ConfigurableReportMaker<S, P extends ReportProvider>
implements ReportMaker {
    private String myType = null;
    private ReportConfig config;
    private Map<SearchFilterControl, Method> methodMap;

    public void setReportConfig(ReportConfig config) {
        this.config = config;
        if (!this.getReportType().equals(config.getType())) {
            throw new IllegalArgumentException("Cannot apply Report Configuration - mismatch " + this.getReportType());
        }
        config.synchronizeFilters(this.getReportFilterControls());
        config.synchronizeReportProperties(this.getReportProperties());
    }

    @Override
    public JasperPrint createJasperReport() {
        if (this.config == null) {
            throw new IllegalStateException("Must set the config before calling a report");
        }
        if (this.getAvailableOutput().contains((Object)ReportOutput.PDF)) {
            S searcher = this.createSearchFilter();
            this.configureSearcher(searcher);
            P provider = this.createReportProvider(searcher);
            try {
                if (provider != null) {
                    return provider.getReportPrint();
                }
            }
            catch (JRException ex) {
                OrderMate.LOG.error("Cannot produce report for type " + this.getReportType(), (Throwable)ex);
            }
        }
        return null;
    }

    @Override
    public String createCsv() {
        if (this.config == null) {
            throw new IllegalStateException("Must set the config before calling a report");
        }
        if (!this.getAvailableOutput().contains((Object)ReportOutput.CSV)) {
            return null;
        }
        S searcher = this.createSearchFilter();
        this.configureSearcher(searcher);
        String csv = null;
        try {
            List<Pair<String, ReportMakerUtility.TabulatedReport>> results = this.tabulateResults((P)searcher);
            csv = ConfigurableReportMaker.createCsv(results);
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot convert report to CSV", (Throwable)ex);
        }
        return csv;
    }

    public P makeProvider() {
        if (this.config == null) {
            throw new IllegalStateException("Must set the config before calling a report");
        }
        S searcher = this.createSearchFilter();
        this.configureSearcher(searcher);
        return this.createReportProvider(searcher);
    }

    public static String createCsv(List<Pair<String, ReportMakerUtility.TabulatedReport>> results) {
        StringBuilder SB = new StringBuilder();
        for (Pair<String, ReportMakerUtility.TabulatedReport> nextReport : results) {
            if (nextReport.value == null) continue;
            String output = ReportMakerUtility.convertToCsv((ReportMakerUtility.TabulatedReport)nextReport.value);
            SB.append((String)nextReport.key).append("\r\n");
            SB.append(output);
        }
        return SB.toString();
    }

    public Object[][] doSortRows(Object[][] toSort) {
        return toSort;
    }

    protected abstract S createSearchFilter();

    protected List<Pair<String, ReportMakerUtility.TabulatedReport>> tabulateResults(S yourSearcher) throws BuilderException {
        return this.tabulateResults(this.createReportProvider(yourSearcher));
    }

    public List<Pair<String, ReportMakerUtility.TabulatedReport>> tabulateResults(P provider) throws BuilderException {
        return ConfigurableReportMaker.tabulateResults(provider, this);
    }

    public static List<Pair<String, ReportMakerUtility.TabulatedReport>> tabulateResults(final ReportProvider provider, ConfigurableReportMaker configurableReportMaker) throws BuilderException {
        if (provider == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Pair<String, ReportMakerUtility.TabulatedReport>> dataList = new ArrayList<Pair<String, ReportMakerUtility.TabulatedReport>>();
        ReportBuilder repBuilder = null;
        if (provider instanceof DataSourceProvider && provider instanceof AbstractReportProvider) {
            repBuilder = ((AbstractReportProvider)provider).getBuilder();
        } else if (provider instanceof OrdermateReportTemplateProvider) {
            repBuilder = ((OrdermateReportTemplateProvider)provider).getBuilder();
        } else {
            OrderMate.LOG.warn("Cannot auto-create tabular data, please implement.");
            return Collections.emptyList();
        }
        if (repBuilder == null) {
            return Collections.EMPTY_LIST;
        }
        if (repBuilder instanceof CustomReportBuilder) {
            try {
                ((CustomReportBuilder)repBuilder).initReport();
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Can't initialize the custom report builder!", (Throwable)ex);
            }
        }
        DynamicReport dynamicReport = repBuilder.buildJasperReport();
        ReportMakerUtility.TabulatedReport tabulatedReport = ReportMakerUtility.tabulateDataSource((DataSourceProvider)((Object)provider), dynamicReport, repBuilder, configurableReportMaker);
        List subReports = repBuilder.getReportBuilder().getConcatenatedReports();
        if (!tabulatedReport.getMetaData().getColumnMetaData().isEmpty()) {
            Pair<String, ReportMakerUtility.TabulatedReport> pair = new Pair<String, ReportMakerUtility.TabulatedReport>(dynamicReport.getTitle(), tabulatedReport);
            dataList.add(pair);
        }
        if (subReports != null && !subReports.isEmpty()) {
            for (int i = 0; i < subReports.size(); ++i) {
                ReportMakerUtility.TabulatedReport tabulatedSubReport;
                final Subreport subreport = (Subreport)subReports.get(i);
                DynamicReport subDr = subreport.getDynamicReport();
                if (subDr == null || (tabulatedSubReport = ReportMakerUtility.tabulateDataSource(new DataSourceProvider(){

                    @Override
                    public JRRewindableDataSource getDataSource() {
                        DJDataSource djsource = subreport.getDatasource();
                        if (djsource == null) {
                            return ((DataSourceProvider)((Object)provider)).getDataSource();
                        }
                        Object dataSource = provider.getParameters().get(djsource.getDataSourceExpression());
                        if (dataSource instanceof JRRewindableDataSource) {
                            JRRewindableDataSource jrw = (JRRewindableDataSource)dataSource;
                            try {
                                jrw.moveFirst();
                            }
                            catch (Exception e) {
                                return ((DataSourceProvider)((Object)provider)).getDataSource();
                            }
                            return jrw;
                        }
                        if (dataSource instanceof TableModel) {
                            if (((TableModel)dataSource).getRowCount() == 0) {
                                return ((DataSourceProvider)((Object)provider)).getDataSource();
                            }
                            return new JRTableModelDataSource((TableModel)dataSource);
                        }
                        if (provider instanceof CustomReportProvider) {
                            return new JRTableModelDataSource(((CustomReportProvider)provider).getCompiler().getDataFor(djsource.getDataSourceExpression()));
                        }
                        JRBeanCollectionDataSource jrBeanDS = new JRBeanCollectionDataSource((Collection)dataSource);
                        if (!jrBeanDS.next()) {
                            return ((DataSourceProvider)((Object)provider)).getDataSource();
                        }
                        return jrBeanDS;
                    }
                }, subDr, repBuilder, configurableReportMaker)) == null || tabulatedSubReport.getMetaData().getColumnMetaData().isEmpty()) continue;
                String title = StringUtils.isEmpty(subDr.getTitle()) ? subreport.getDatasource().getDataSourceExpression() : subDr.getTitle();
                dataList.add(new Pair<String, ReportMakerUtility.TabulatedReport>(title, tabulatedSubReport));
            }
        }
        return dataList;
    }

    protected abstract P createReportProvider(S var1);

    @Override
    public TableModel createTableModel() {
        return null;
    }

    @Override
    public List<SearchFilterControl> getReportFilterControls() {
        if (this.methodMap == null) {
            Method[] methods;
            this.methodMap = new HashMap<SearchFilterControl, Method>();
            SearchFilterControlFactory factory = new SearchFilterControlFactory();
            S searcher = this.createSearchFilter();
            if (ReportMakerSearchControls.containsSearcher(searcher.getClass().getName())) {
                this.methodMap = ReportMakerSearchControls.getSearchControlMap(searcher.getClass().getName());
                return new ArrayList<SearchFilterControl>(this.methodMap.keySet());
            }
            for (Method nextMethod : methods = searcher.getClass().getMethods()) {
                FilterConfig filterConfig;
                if (!SearchFilterI.class.isAssignableFrom(nextMethod.getReturnType()) || (filterConfig = nextMethod.getAnnotation(FilterConfig.class)) == null || filterConfig.ignore() || nextMethod.isSynthetic() || nextMethod.isBridge()) continue;
                this.methodMap.put(factory.createFilterControl(filterConfig), nextMethod);
            }
            ReportMakerSearchControls.addSearcherControlMap(searcher.getClass().getName(), this.methodMap);
        }
        return new ArrayList<SearchFilterControl>(this.methodMap.keySet());
    }

    @Override
    public String getReportType() {
        if (this.myType == null) {
            this.myType = this.getClass().getAnnotation(MakesReport.class).value();
        }
        return this.myType;
    }

    @Override
    public Class getProvider() {
        Class<?> clazz = this.getClass();
        ParameterizedType type = (ParameterizedType)clazz.getGenericSuperclass();
        Type t = type.getActualTypeArguments()[1];
        return (Class)t;
    }

    public ReportConfig getReportConfig() {
        return this.config;
    }

    protected void configureSearcher(S theSearcher) {
        if (this.config == null) {
            throw new IllegalStateException("Must set the config before calling a report");
        }
        this.getReportFilterControls();
        for (SearchFilterControl control : this.methodMap.keySet()) {
            String value = this.retrieveFilterValueFor(control.getName());
            SearchFilterI filter = this.getSearchFilter(this.methodMap.get(control), theSearcher);
            if (filter == null) continue;
            control.parseAndSetValue(value, filter);
        }
    }

    protected String retrieveFilterValueFor(String filterName) {
        if (this.config == null) {
            return null;
        }
        for (ReportConfigFilter filter : this.config.getFilters()) {
            if (!filterName.equals(filter.getFilterName())) continue;
            return filter.getSearchValue();
        }
        return null;
    }

    private SearchFilterI getSearchFilter(Method toCall, S searcher) {
        try {
            return (SearchFilterI)toCall.invoke(searcher, new Object[0]);
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot retrieve filter from searcher", (Throwable)ex);
            return null;
        }
    }

    @Override
    public Set<ReportOutput> getAvailableOutput() {
        return ReportOutput.all;
    }

    @Override
    public List<ReportProperty> getReportProperties() {
        return Collections.emptyList();
    }
}

