/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.maker;

import au.com.ordermate.reports.MakesReport;
import au.com.ordermate.reports.ReportMaker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ordermate.OrderMate;
import ordermate.database.config.report.ReportConfig;
import ordermate.database.misc.SystemProperty;
import ordermate.database.reports.maker.ConfigurableReportMaker;
import ordermate.database.reports.maker.ReportMeta;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.TypeAnnotationsScanner;

public class OMReportMakerFactory {
    private static final String STOCK = "Stock";
    private static final String pathToExamine = "ordermate.database.reports";
    private Map<String, Class<? extends ReportMaker>> reportMakerClasses;
    private Map<String, ReportMeta> reportMakerMeta;
    private static volatile OMReportMakerFactory instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OMReportMakerFactory getInstance() {
        if (instance != null) return instance;
        Class<OMReportMakerFactory> clazz = OMReportMakerFactory.class;
        synchronized (OMReportMakerFactory.class) {
            if (instance != null) return instance;
            instance = new OMReportMakerFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private OMReportMakerFactory() {
        this.examinePathForClasses();
    }

    private void examinePathForClasses() {
        this.reportMakerClasses = new HashMap<String, Class<? extends ReportMaker>>();
        this.reportMakerMeta = new HashMap<String, ReportMeta>();
        this.populateWithPackage();
    }

    private void populateWithPackage() {
        Reflections refs = new Reflections(pathToExamine, new Scanner[]{new TypeAnnotationsScanner()});
        Set classes = refs.getTypesAnnotatedWith(MakesReport.class);
        boolean hasStock = SystemProperty.getInstance().isStockControlEnabled();
        for (Class clazz : classes) {
            MakesReport engine = clazz.getAnnotation(MakesReport.class);
            String value = engine.value();
            OrderMate.LOG.info("Found Report Engine " + value);
            if (hasStock || !STOCK.equals(engine.category())) {
                this.reportMakerClasses.put(value, clazz);
                ReportMeta meta = new ReportMeta(engine.description(), engine.category(), engine.subcategory(), engine.period(), engine.columnMetaData(), engine.permission());
                this.reportMakerMeta.put(value, meta);
                continue;
            }
            OrderMate.LOG.info("Skipping because Stock is not enabled on this machine");
        }
    }

    public ConfigurableReportMaker createReportMaker(ReportConfig config) {
        ConfigurableReportMaker maker = (ConfigurableReportMaker)this.createReportMaker(config.getType());
        if (maker != null) {
            maker.setReportConfig(config);
        }
        return maker;
    }

    public ReportMaker createReportMaker(String reportMakerName) {
        Class<? extends ReportMaker> clazz = this.reportMakerClasses.get(reportMakerName);
        if (clazz != null) {
            try {
                ReportMaker engine = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                return engine;
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Cannot instantiate class of ReportMaker of type " + reportMakerName, (Throwable)ex);
            }
        } else {
            OrderMate.LOG.error("Cannot instantiate ReportMaker for null class type " + reportMakerName);
        }
        return null;
    }

    public List<String> getTypes() {
        ArrayList<String> types = new ArrayList<String>(this.reportMakerClasses.keySet());
        Collections.sort(types);
        return types;
    }

    public ReportMeta getMeta(String key) {
        return this.reportMakerMeta.get(key);
    }
}

