/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.maker;

import ar.com.fdvs.dj.domain.CustomExpression;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.columns.ExpressionColumn;
import ar.com.fdvs.dj.domain.entities.columns.PropertyColumn;
import ar.com.fdvs.dj.domain.entities.columns.SimpleColumn;
import au.com.bytecode.opencsv.CSVWriter;
import au.com.ordermate.persistence.PersistentEnumeration;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.reports.ReportConfigureColumnMetaData;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.StringUtils;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Time;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.design.JRDesignField;
import ordermate.OrderMate;
import ordermate.database.config.Quantity;
import ordermate.database.reports.maker.ConfigurableReportMaker;
import ordermate.database.reports.maker.OMReportMakerFactory;
import ordermate.database.reports.maker.ReportMeta;
import ordermate.reports.dynamicjasper.ReportBuilder;
import ordermate.reports.dynamicjasper.customexpressions.ArrayResolverExpression;
import ordermate.reports.dynamicjasper.reportbuilder.DataSourceProvider;

public class ReportMakerUtility {
    private ReportMakerUtility() {
    }

    public static String convertToCsv(TabulatedReport report) {
        StringWriter writer = new StringWriter();
        CSVWriter csvWriter = new CSVWriter((Writer)writer);
        ArrayList<String[]> all = new ArrayList<String[]>();
        List<ReportColumnMetaData> columnsMeta = report.getMetaData().getColumnMetaData();
        Format[] formatters = new Format[columnsMeta.size()];
        ArrayList<String> newRow = new ArrayList<String>(formatters.length);
        for (int i = 0; i < formatters.length; ++i) {
            ReportColumnMetaData colMeta = columnsMeta.get(i);
            if (!StringUtils.isEmpty(colMeta.pattern)) {
                if (Number.class.getSimpleName().toLowerCase().equals(colMeta.type)) {
                    formatters[i] = new DecimalFormat(colMeta.pattern);
                } else if (Date.class.getSimpleName().toLowerCase().equals(colMeta.type)) {
                    formatters[i] = new SimpleDateFormat(colMeta.pattern);
                } else if (Time.class.getSimpleName().toLowerCase().equals(colMeta.type)) {
                    formatters[i] = new SimpleDateFormat(colMeta.pattern);
                }
            }
            newRow.add(colMeta.header);
        }
        all.add(newRow.toArray(new String[newRow.size()]));
        for (int row = 1; row < report.data.length; ++row) {
            Object[] nextRow = report.data[row];
            newRow = new ArrayList();
            for (int i = 0; i < nextRow.length; ++i) {
                if (formatters[i] != null) {
                    try {
                        newRow.add(nextRow[i] == null ? null : formatters[i].format(nextRow[i]));
                    }
                    catch (Exception e) {
                        newRow.add(String.valueOf(nextRow[i]));
                    }
                    continue;
                }
                newRow.add(nextRow[i] == null ? null : String.valueOf(nextRow[i]));
            }
            all.add(newRow.toArray(new String[newRow.size()]));
        }
        csvWriter.writeAll(all);
        try {
            csvWriter.close();
            writer.close();
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot close off CSV Writer for scheduled report ", (Throwable)ex);
        }
        return writer.toString();
    }

    public static TabulatedReport tabulateDataSource(DataSourceProvider dataProvider, DynamicReport dr, ReportBuilder builder, ConfigurableReportMaker configurableReportMaker) {
        JRRewindableDataSource source = dataProvider.getDataSource();
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        try {
            List columns = dr.getColumns();
            ArrayList<JRDesignField> fields = new ArrayList<JRDesignField>();
            ArrayList<String> headers = new ArrayList<String>();
            for (int i = 0; i < columns.size(); ++i) {
                AbstractColumn column = (AbstractColumn)columns.get(i);
                if (!(column instanceof PropertyColumn)) continue;
                JRDesignField field = new JRDesignField();
                field.setName(((PropertyColumn)column).getColumnProperty().getProperty());
                field.setValueClassName(column.getValueClassNameForExpression());
                field.setValueClass(Class.forName(column.getValueClassNameForExpression()));
                if (column instanceof SimpleColumn) {
                    field.setDescription(((SimpleColumn)column).getFieldDescription());
                }
                String title = column.getTitle();
                if (field.getName() == null || field.getName().startsWith("__") || field.getName().startsWith("customExpression")) {
                    PropertyColumn propertyColumn = (PropertyColumn)column;
                    PropertiedObject.Property property = builder.getPropertyForColumn(propertyColumn);
                    if (property != null) {
                        field.setName(property.getName());
                        field.setDescription(property.getName());
                    } else {
                        CustomExpression exp;
                        title = StringUtils.camelCaseToDisplayableAcronyms(StringUtils.firstCharToUpperCase(column.getTitle()));
                        field.setName(column.getTitle());
                        field.setDescription(column.getTitle());
                        if (column instanceof ExpressionColumn && (exp = ((ExpressionColumn)column).getExpression()) instanceof ArrayResolverExpression) {
                            field.setName(((ArrayResolverExpression)exp).getResolvedFieldName());
                            field.setDescription(null);
                        }
                    }
                }
                fields.add(field);
                if (StringUtils.isEmpty(title)) {
                    title = StringUtils.camelCaseToDisplayable(StringUtils.firstCharToUpperCase(field.getName()));
                }
                if (title.contains("\\")) {
                    title = title.replace("\\", "");
                }
                headers.add(title);
            }
            rows.add(headers.toArray(new String[headers.size()]));
            TabulatedReportMetaData meta = new TabulatedReportMetaData();
            Map<String, Integer> groupedColumnMap = ReportMakerUtility.getGroupedColumnMap(configurableReportMaker);
            Map<String, Boolean> totaledColumnMap = ReportMakerUtility.getTotaledColumnMap(configurableReportMaker);
            Map<String, Boolean> lockedColumnMap = ReportMakerUtility.getLockedColumnMap(configurableReportMaker);
            if (!columns.isEmpty()) {
                boolean metaLatch = false;
                source.moveFirst();
                while (source.next()) {
                    Object[] row = new Object[fields.size()];
                    for (int i = 0; i < row.length; ++i) {
                        JRDesignField field = (JRDesignField)fields.get(i);
                        Object value = null;
                        try {
                            value = source.getFieldValue((JRField)field);
                        }
                        catch (JRException e) {
                            e.printStackTrace();
                        }
                        String pattern = ((AbstractColumn)columns.get(i)).getPattern();
                        if (value instanceof Number) {
                            if (value instanceof Price) {
                                value = ((Price)value).toBigDecimal();
                            } else if (value instanceof Quantity) {
                                value = ((Quantity)value).bigDecimalValue();
                            }
                        } else if (value instanceof PersistentObject) {
                            value = String.valueOf(value);
                        } else if (value instanceof Date && pattern == null) {
                            pattern = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";
                        }
                        row[i] = value;
                        if (metaLatch) continue;
                        int grouped = -1;
                        if (groupedColumnMap != null) {
                            grouped = groupedColumnMap.get(headers.get(i)) == null ? -1 : groupedColumnMap.get(headers.get(i));
                        }
                        boolean totaled = false;
                        if (totaledColumnMap != null) {
                            totaled = totaledColumnMap.get(headers.get(i)) == null ? false : totaledColumnMap.get(headers.get(i));
                        }
                        boolean locked = false;
                        if (lockedColumnMap != null) {
                            locked = lockedColumnMap.get(headers.get(i)) == null ? false : lockedColumnMap.get(headers.get(i));
                        }
                        meta.columns.add(new ReportColumnMetaData((String)headers.get(i), ReportMakerUtility.determineType(value, pattern), pattern, grouped, totaled, locked));
                    }
                    rows.add(row);
                    metaLatch = true;
                }
            }
            Object[][] finalData = new Object[rows.size()][];
            for (int i = 0; i < rows.size(); ++i) {
                finalData[i] = (Object[])rows.get(i);
            }
            return new TabulatedReport(finalData, meta);
        }
        catch (JRException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Map<String, Integer> getGroupedColumnMap(ConfigurableReportMaker configurableReportMaker) {
        if (configurableReportMaker == null) {
            return null;
        }
        ReportMeta meta = OMReportMakerFactory.getInstance().getMeta(configurableReportMaker.getReportType());
        if (meta.columns == null || meta.columns.length == 0) {
            return null;
        }
        HashMap<String, Integer> groupedColumnMap = new HashMap<String, Integer>();
        for (ReportConfigureColumnMetaData element : meta.columns) {
            groupedColumnMap.put(element.name(), element.grouped());
        }
        return groupedColumnMap;
    }

    public static Map<String, Boolean> getTotaledColumnMap(ConfigurableReportMaker configurableReportMaker) {
        if (configurableReportMaker == null) {
            return null;
        }
        ReportMeta meta = OMReportMakerFactory.getInstance().getMeta(configurableReportMaker.getReportType());
        if (meta.columns == null || meta.columns.length == 0) {
            return null;
        }
        HashMap<String, Boolean> totaledColumnMap = new HashMap<String, Boolean>();
        for (ReportConfigureColumnMetaData element : meta.columns) {
            totaledColumnMap.put(element.name(), element.totaled());
        }
        return totaledColumnMap;
    }

    public static Map<String, Boolean> getLockedColumnMap(ConfigurableReportMaker configurableReportMaker) {
        if (configurableReportMaker == null) {
            return null;
        }
        ReportMeta meta = OMReportMakerFactory.getInstance().getMeta(configurableReportMaker.getReportType());
        if (meta.columns == null || meta.columns.length == 0) {
            return null;
        }
        HashMap<String, Boolean> lockedColumnMap = new HashMap<String, Boolean>();
        for (ReportConfigureColumnMetaData element : meta.columns) {
            lockedColumnMap.put(element.name(), element.locked());
        }
        return lockedColumnMap;
    }

    private static String determineType(Object value, String pattern) {
        Class clazz = String.class;
        if (value != null) {
            if (value instanceof Number) {
                clazz = Number.class;
            } else if (value instanceof PersistentEnumeration) {
                clazz = Enum.class;
            } else if (value instanceof Enum) {
                clazz = Enum.class;
            } else if (value instanceof Time) {
                clazz = Time.class;
            } else if (value instanceof Date) {
                clazz = Date.class;
            }
        } else if (!StringUtils.isEmpty(pattern)) {
            if (pattern.contains("$")) {
                clazz = Number.class;
            } else if (pattern.contains(".")) {
                clazz = Number.class;
            } else if (pattern.contains("0")) {
                clazz = Number.class;
            } else if (pattern.contains("d") || pattern.contains("M") || pattern.contains("y")) {
                clazz = Date.class;
            } else if (pattern.contains("m")) {
                clazz = Time.class;
            }
        }
        return clazz.getSimpleName().toLowerCase();
    }

    public static class ReportColumnMetaData {
        public final String header;
        public final String type;
        public final String pattern;
        public final int grouped;
        public final boolean totaled;
        public final boolean locked;

        public ReportColumnMetaData(String header, String theType, String pattern, int grouped, boolean totaled, boolean locked) {
            this.header = header;
            this.type = theType;
            this.pattern = pattern;
            this.grouped = grouped;
            this.totaled = totaled;
            this.locked = locked;
        }
    }

    public static class TabulatedReportMetaData {
        private final Date created = new Date();
        private final List<ReportColumnMetaData> columns = new ArrayList<ReportColumnMetaData>();

        public List<ReportColumnMetaData> getColumnMetaData() {
            return this.columns;
        }

        public Date getDateCreated() {
            return this.created;
        }
    }

    public static class TabulatedReport {
        private final Object[][] data;
        private final TabulatedReportMetaData metaData;

        public TabulatedReport(Object[][] data, TabulatedReportMetaData metaData) {
            this.data = data;
            this.metaData = metaData;
        }

        public Object[][] getData() {
            return this.data;
        }

        public TabulatedReportMetaData getMetaData() {
            return this.metaData;
        }
    }
}

