/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.options;

import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.DJGroupLabel;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.BuilderException;
import ar.com.fdvs.dj.domain.constants.GroupLayout;
import ar.com.fdvs.dj.domain.constants.LabelPosition;
import ar.com.fdvs.dj.domain.entities.DJGroup;
import ar.com.fdvs.dj.domain.entities.columns.PropertyColumn;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.IRangedSearchFilter;
import au.com.ordermate.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import ordermate.database.config.ExperimentalFeatureHelper;
import ordermate.database.reports.ReportProviderHelper;
import ordermate.database.reports.sales.general.OptionSoldReport;
import ordermate.database.searchers.reports.TradingDayFilteredReportSearcher;
import ordermate.database.searchers.reports.sales.general.OptionSoldReportSearcher;
import ordermate.internationalization.Internationalization;
import ordermate.reports.dynamicjasper.OrderMateOmorphosReportStyle;
import ordermate.reports.dynamicjasper.PeriodReportAdapter;
import ordermate.reports.dynamicjasper.ReportBuilder;
import ordermate.reports.dynamicjasper.reportbuilder.AbstractReportProvider;
import ordermate.reports.impl.SearcherDataSourceProvider;

public class OptionsReportProvider
extends AbstractReportProvider {
    private SearcherDataSourceProvider<OptionSoldReportSearcher> searcherDataSourceProvider;

    public OptionsReportProvider(OptionSoldReportSearcher searcher) {
        this.searcherDataSourceProvider = new SearcherDataSourceProvider<OptionSoldReportSearcher>(searcher);
    }

    @Override
    public ReportBuilder getBuilder() throws BuilderException {
        ReportBuilder builder = new ReportBuilder(new OrderMateOmorphosReportStyle());
        this.getParameters().putAll(builder.addBusinessLogoDetailHeaderAndFooterTemplate());
        builder.setTitle("Menu Option Sales");
        OptionSoldReportSearcher reportSearcher = this.searcherDataSourceProvider.getSearch();
        IRangedSearchFilter dateRangeFilter = reportSearcher.getTradingDayDateRangeFilter();
        IRangedQuerySearchFilter<Date> dateRangeAdapter = reportSearcher.getTradingDayDateRangeAdapter();
        PeriodReportAdapter period = reportSearcher.getPeriod();
        StringBuilder subTitle = new StringBuilder();
        if (period == null) {
            subTitle.append(TradingDayFilteredReportSearcher.DisplayHelper.getDisplayableDate(dateRangeAdapter));
        } else {
            subTitle.append(period.formatTradingDayRangeForDisplay((Date)dateRangeFilter.getStart(), (Date)dateRangeFilter.getEnd(), (Date)dateRangeAdapter.getEnd()));
        }
        String timeString = reportSearcher.getTimeFilter().getDisplayableTime();
        if (!timeString.isEmpty()) {
            this.getHelper().appendSubTitleAndValue(subTitle, "Day Part", timeString);
        }
        this.getHelper().appendSearchFilter(subTitle, "Option Group", reportSearcher.getOptionGroupFilter());
        this.getHelper().appendSearchFilter(subTitle, "Size", reportSearcher.getSizeFilter());
        this.getHelper().appendSearchFilter(subTitle, "Text Search", reportSearcher.getTextFilter());
        this.getHelper().appendSearchFilter(subTitle, "Sales Location", reportSearcher.getSalesLocationFilter());
        builder.setSubtitle(subTitle.toString());
        List<Pair<? extends PropertiedObject.Property, String>> pairs = this.getColumnsAndNames();
        for (Pair<? extends PropertiedObject.Property, String> nextPair : pairs) {
            builder.addReportColumn(nextPair.getKey(), nextPair.getValue(), null);
        }
        builder.getPropertyColumn(OptionSoldReport.Properties.QUANTITY).setPattern("0");
        builder.getPropertyColumn(OptionSoldReport.Properties.SALES_VALUE).setPattern(Internationalization.getLiteralFor("DOLLAR_SIGN") + "0.00");
        ReportBuilder.PropertyCalculation sumQty = new ReportBuilder.PropertyCalculation(OptionSoldReport.Properties.QUANTITY, DJCalculation.SUM);
        ReportBuilder.PropertyCalculation sumSales = new ReportBuilder.PropertyCalculation(OptionSoldReport.Properties.SALES_VALUE, DJCalculation.SUM);
        DJGroup group = builder.addGroupBy(OptionSoldReport.Properties.OPTION_GROUP_AND_SIZE, Arrays.asList(sumQty, sumSales));
        DJGroupLabel footerLabel = new DJGroupLabel("Total: ", builder.getStyles().getFooterVariableStyle(), LabelPosition.LEFT);
        group.setFooterLabel(footerLabel);
        this.setupGrouping(group, builder);
        builder.getReportBuilder().setAllowDetailSplit(true);
        return builder;
    }

    protected void setupGrouping(DJGroup group, ReportBuilder builder) {
        group.setLayout(GroupLayout.VALUE_IN_HEADER_WITH_HEADERS_AND_COLUMN_NAME);
        group.setReprintHeaderOnEachPage(Boolean.TRUE);
        group.setAllowHeaederSplit(false);
        group.setAllowFooterSplit(false);
        group.setHeaderHeight(Integer.valueOf(15));
        Style groupedColumnStyle = builder.getStyles().getGroupedDetailStyle();
        PropertyColumn groupCol = builder.getPropertyColumn(OptionSoldReport.Properties.OPTION_GROUP_AND_SIZE);
        groupCol.setHeaderStyle(groupedColumnStyle);
        groupCol.setStyle(groupedColumnStyle);
        this.hideColumnName(groupCol);
    }

    protected List<Pair<? extends PropertiedObject.Property, String>> getColumnsAndNames() {
        ArrayList<Pair<? extends PropertiedObject.Property, String>> pairs = new ArrayList<Pair<? extends PropertiedObject.Property, String>>();
        pairs.add(Pair.make(OptionSoldReport.Properties.OPTION_GROUP_AND_SIZE, "Group and Size"));
        if (ExperimentalFeatureHelper.isShowItemIds()) {
            pairs.add(Pair.make(OptionSoldReport.Properties.OPTION_ID, "Option ID"));
        }
        pairs.add(Pair.make(OptionSoldReport.Properties.OPTION_NAME, "Option"));
        pairs.add(Pair.make(OptionSoldReport.Properties.AVERAGE_PRICE, "Price"));
        pairs.add(Pair.make(OptionSoldReport.Properties.QUANTITY, "Qty Sold"));
        pairs.add(Pair.make(OptionSoldReport.Properties.SALES_VALUE, "Value Sold"));
        return pairs;
    }

    @Override
    protected DynamicReport getReport() throws BuilderException {
        return this.getBuilder().buildJasperReport();
    }

    @Override
    public JRRewindableDataSource getDataSource() {
        return this.searcherDataSourceProvider.getDataSource();
    }

    @Override
    protected String getAdditionalFooterText() {
        return "Sales in this report are being filtered based on " + ReportProviderHelper.describeRangeFilter(this.searcherDataSourceProvider.getSearch().getTradingDayDateRangeFilter());
    }
}

