/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.payroll;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.RangeJoinSearchFilter;
import java.util.Date;
import ordermate.database.filters.OptimisedDateRangeSearchFilter;
import ordermate.database.filters.TradingDayDateRangeFilterAdapter;
import ordermate.database.finance.timesheet.FinanceTimesheet;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.payroll.PayrollReport;

public class PayrollSearcher
extends PropertySearcher<PayrollReport> {
    private RangeJoinSearchFilter<Date> dateRangeFilter;
    private IRangedQuerySearchFilter<Date> tradingDayDateRangeAdapter;

    public PayrollSearcher() {
        super(PayrollReport.class);
        this.dateRangeFilter = new RangeJoinSearchFilter<Date>(new OptimisedDateRangeSearchFilter(TradingDay.Properties.DATE, SQLDateType.DATE), FinanceTimesheet.Properties.TRADING_DAY);
        this.tradingDayDateRangeAdapter = new TradingDayDateRangeFilterAdapter(this.dateRangeFilter);
        this.addSearchFilter(this.tradingDayDateRangeAdapter);
    }

    @Override
    protected ObjectQuery getBaseQuery() {
        return Query.select(FinanceTimesheet.Properties.ID).selectFunc("TIMESTAMPDIFF(MINUTE, ifnull(mod_time_in, Time_IN), ifnull(finance_timesheet.mod_time_out, finance_timesheet.Time_OUT)) as time_in_seconds");
    }

    public IRangedQuerySearchFilter<Date> getTradingDayDateRangeFilter() {
        return this.dateRangeFilter;
    }

    public IRangedQuerySearchFilter<Date> getTradingDayDateRangeAdapter() {
        return this.tradingDayDateRangeAdapter;
    }
}

