/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.periodstock;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ordermate.database.reports.periodstock.PeriodStockAreaReportCreator;
import ordermate.database.reports.periodstock.PeriodStockAreaReportItem;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockTake;

public class PeriodStockAreaReport {
    List<PeriodStockAreaReportItem> reportItems = new ArrayList<PeriodStockAreaReportItem>();
    private StockTake end;
    private StockTake start;

    public PeriodStockAreaReport(StockTake theStart, StockTake theEnd) {
        this.end = theEnd;
        this.start = theStart;
        this.init();
    }

    private void init() {
        this.reportItems.clear();
        PeriodStockAreaReportCreator creator = new PeriodStockAreaReportCreator();
        this.reportItems.addAll(creator.createAndCompileReports(this.start, this.end));
    }

    public List<PeriodStockAreaReportItem> getReportItems() {
        return this.reportItems;
    }

    public List<PeriodStockAreaReportItem> getReportItems(List<StockArea> areas) {
        ArrayList<PeriodStockAreaReportItem> filteredReportItems = new ArrayList<PeriodStockAreaReportItem>(areas.size());
        for (StockArea area : areas) {
            for (PeriodStockAreaReportItem item : this.reportItems) {
                if (!area.equals(item.getArea())) continue;
                filteredReportItems.add(item);
            }
        }
        return filteredReportItems;
    }

    public PeriodStockAreaReport refresh() {
        this.init();
        return this;
    }

    public Date getStartDate() {
        return this.start != null ? this.start.getDate() : new Date();
    }

    public Date getEnd() {
        return this.end != null ? this.end.getDate() : new Date();
    }

    public void setPeriod(StockTake start, StockTake end) {
        this.start = start;
        this.end = end;
        this.init();
    }
}

