/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.periodstock;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.Price;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ordermate.database.queries.stock.StockAreaQueries;
import ordermate.database.queries.stock.StockInvoiceQueries;
import ordermate.database.queries.stock.StockOnHandQueries;
import ordermate.database.queries.stock.StockTakeQueries;
import ordermate.database.queries.stock.StockUsageQueries;
import ordermate.database.reports.periodstock.PeriodStockAreaReportItem;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockTake;

public class PeriodStockAreaReportCreator {
    public List<PeriodStockAreaReportItem> createAndCompileReports(StockTake start, StockTake end) {
        return this.compileReports(this.createPeriodStockAreaReportItems(start, end));
    }

    protected List<PeriodStockAreaReportItem> createPeriodStockAreaReportItems(StockTake start, StockTake end) {
        ArrayList<StockTake> allTakes = new ArrayList<StockTake>();
        if (start != null && start.equals(end)) {
            allTakes.add(start);
            allTakes.add(end);
        } else {
            for (StockTake next = start; next != null && !next.equals(end); next = next.getNextStockTake()) {
                allTakes.add(next);
            }
            if (!allTakes.contains(end)) {
                allTakes.add(end);
            }
        }
        ArrayList<PeriodStockAreaReportItem> persistedReports = new ArrayList<PeriodStockAreaReportItem>();
        for (int i = 0; i < allTakes.size() - 1; ++i) {
            StockTake first = (StockTake)allTakes.get(i);
            StockTake last = (StockTake)allTakes.get(i + 1);
            List<PeriodStockAreaReportItem> reports = this.createReportItemsFor(first, last);
            if (first != null && last != null && !first.isLive() && !first.equals(last)) {
                this.updatePersistedReports(last, reports);
            }
            persistedReports.addAll(reports);
        }
        return persistedReports;
    }

    public List<PeriodStockAreaReportItem> compileReports(List<PeriodStockAreaReportItem> reports) {
        HashMap<String, PeriodStockAreaReportItem> reportMap = new HashMap<String, PeriodStockAreaReportItem>();
        this.aggregateReports(reportMap, reports);
        return this.orderReports(reportMap.values());
    }

    private List<PeriodStockAreaReportItem> orderReports(Collection<PeriodStockAreaReportItem> reports) {
        ArrayList<PeriodStockAreaReportItem> finalItems = new ArrayList<PeriodStockAreaReportItem>(reports);
        Collections.sort(finalItems, new Comparator<PeriodStockAreaReportItem>(){

            @Override
            public int compare(PeriodStockAreaReportItem o1, PeriodStockAreaReportItem o2) {
                return o1.getStockAreaLabel().compareTo(o1.getStockAreaLabel());
            }
        });
        return finalItems;
    }

    private void aggregateReports(Map<String, PeriodStockAreaReportItem> reportMap, List<PeriodStockAreaReportItem> reports) {
        for (PeriodStockAreaReportItem nextReport : reports) {
            if (!reportMap.containsKey(nextReport.getStockAreaLabel())) {
                reportMap.put(nextReport.getStockAreaLabel(), nextReport);
                continue;
            }
            reportMap.get(nextReport.getStockAreaLabel()).aggregate(nextReport);
        }
    }

    private List<PeriodStockAreaReportItem> findPersistedReports(StockTake stockTake) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(stockTake.getDate());
        cal.set(14, 0);
        ObjectQuery query = Query.select(PeriodStockAreaReportItem.class).equals(PeriodStockAreaReportItem.Properties.PERIOD_END, cal.getTime(), SQLDateType.TIMESTAMP);
        return PersistenceManager.getObjectList(PeriodStockAreaReportItem.class, query.toString(), null);
    }

    private void updatePersistedReports(StockTake take, List<PeriodStockAreaReportItem> newReports) {
        List<PeriodStockAreaReportItem> persistedReports = this.findPersistedReports(take);
        ArrayList<PeriodStockAreaReportItem> allReports = new ArrayList<PeriodStockAreaReportItem>();
        for (PeriodStockAreaReportItem newReport : newReports) {
            boolean found = false;
            for (PeriodStockAreaReportItem persistedReport : persistedReports) {
                if (!persistedReport.getArea().equals(newReport.getArea())) continue;
                found = true;
                persistedReport.updateReportValues(newReport);
                persistedReport.save();
                allReports.add(persistedReport);
                break;
            }
            if (found) continue;
            PeriodStockAreaReportItem item = new PeriodStockAreaReportItem(newReport.getArea(), take);
            item.updateReportValues(newReport);
            if (take != null) {
                item.save();
            }
            allReports.add(item);
        }
        newReports.clear();
        newReports.addAll(allReports);
    }

    private List<PeriodStockAreaReportItem> createReportItemsFor(StockTake start, StockTake end) {
        Object[][] closingStockTakeData = null;
        Object[][] closingStockOnHandData = null;
        Object[][] openingStockTakeData = null;
        Object[][] adjustData = null;
        Object[][] incomingTransferData = null;
        Object[][] outgoingTransferData = null;
        Object[][] wasteData = null;
        Object[][] yieldData = null;
        Object[][] purchaseData = null;
        Object[][] purchaseExtrasData = null;
        Timestamp sqlFrom = new Timestamp(start.getDate().getTime());
        Timestamp sqlTo = end != null ? new Timestamp(end.getDate().getTime()) : new Timestamp(System.currentTimeMillis());
        Object[][] salesData = PersistenceManager.getPersistenceDelegate().executeQuery(StockAreaQueries.Reports.GetSalesAndCOGS.QUERY_PER_AREA, new Object[]{sqlFrom, sqlTo});
        if (end != null) {
            closingStockTakeData = PersistenceManager.getPersistenceDelegate().executeQuery(StockTakeQueries.Reports.GetStockTakeValue.QUERY_FOR_STOCKTAKE, new Object[]{end.getID()});
        } else {
            closingStockOnHandData = PersistenceManager.getPersistenceDelegate().executeQuery(StockOnHandQueries.Reports.GetStockOnHandValue.getQueryPerArea(), null);
        }
        openingStockTakeData = PersistenceManager.getPersistenceDelegate().executeQuery(StockTakeQueries.Reports.GetStockTakeValue.QUERY_FOR_STOCKTAKE, new Object[]{start.getID()});
        adjustData = PersistenceManager.getPersistenceDelegate().executeQuery(StockUsageQueries.Reports.GetUsages.QUERY_PER_AREA, new Object[]{sqlFrom, sqlTo, "ADJUST"});
        incomingTransferData = PersistenceManager.getPersistenceDelegate().executeQuery(StockAreaQueries.Reports.GetIncomingTransferValue.QUERY, new Object[]{sqlFrom, sqlTo});
        outgoingTransferData = PersistenceManager.getPersistenceDelegate().executeQuery(StockAreaQueries.Reports.GetOutgoingTransferValue.QUERY, new Object[]{sqlFrom, sqlTo});
        wasteData = PersistenceManager.getPersistenceDelegate().executeQuery(StockUsageQueries.Reports.GetUsages.QUERY_PER_AREA, new Object[]{sqlFrom, sqlTo, "WASTED"});
        yieldData = PersistenceManager.getPersistenceDelegate().executeQuery(StockUsageQueries.Reports.GetUsages.QUERY_PER_AREA, new Object[]{sqlFrom, sqlTo, "YIELD"});
        purchaseData = PersistenceManager.getPersistenceDelegate().executeQuery(StockInvoiceQueries.Reports.GetInvoiceCost.QUERY_PER_AREA, new Object[]{sqlFrom, sqlTo});
        purchaseExtrasData = PersistenceManager.getPersistenceDelegate().executeQuery(StockInvoiceQueries.Reports.GetInvoiceExtraCosts.QUERY_PER_AREA, new Object[]{sqlFrom, sqlTo});
        ArrayList<PeriodStockAreaReportItem> reportItems = new ArrayList<PeriodStockAreaReportItem>();
        for (StockArea area : StockArea.getStockAreas()) {
            PeriodStockAreaReportItem item = new PeriodStockAreaReportItem(area, end);
            item.setOpeningStock(this.getStockAreaValue(openingStockTakeData, 4, 1, area));
            item.setPurchasesStock(this.getStockAreaValue(purchaseData, 2, 1, area));
            item.setPurchasesFees(this.getStockAreaValue(purchaseExtrasData, 2, 1, area));
            item.setIncomingTransfers(this.getStockAreaValue(incomingTransferData, 1, 3, area));
            item.setOutgoingTransfers(this.getStockAreaValue(outgoingTransferData, 1, 3, area));
            if (end != null) {
                item.setClosingStock(this.getStockAreaValue(closingStockTakeData, 4, 1, area));
            } else {
                item.setClosingStock(this.getStockAreaValue(closingStockOnHandData, 2, 1, area));
            }
            item.setSalesInc(this.getStockAreaValue(salesData, 5, 0, area));
            item.setSalesExTax(this.getStockAreaValue(salesData, 5, 1, area));
            item.setWastage(this.getStockAreaValue(wasteData, 9, 8, area));
            item.setYield(this.getStockAreaValue(yieldData, 9, 8, area));
            Price variance = Price.ZERO_DOLLAR;
            for (StockTake current = start; current != null && !current.isLive(); current = current.getNextStockTake()) {
                variance = variance.add(current.getVarianceValue(area));
                if (current.equals(end)) break;
            }
            item.setStockTakeVar(variance);
            item.setAdjustments(this.getStockAreaValue(adjustData, 9, 8, area));
            reportItems.add(item);
        }
        return reportItems;
    }

    private Price getStockAreaValue(Object[][] data, int areaCol, int valueCol, StockArea area) {
        Price value = Price.ZERO_NO_ROUND;
        for (int i = 0; i < data.length; ++i) {
            if (!data[i][areaCol].equals(area.getID())) continue;
            value = value.add(new Price((Double)data[i][valueCol], 0.0));
        }
        return value;
    }
}

