/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.periodstock;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.util.FinanceUtils;
import au.com.ordermate.util.Price;
import java.util.Calendar;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockTake;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@Table(name="report_period_stock")
@AccessType(value="property")
public class PeriodStockAreaReportItem
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    private Reference<StockArea> area;
    private String stockAreaLabel;
    private Date periodEnd;
    private Price openingStock;
    private Price purchasesStock;
    private Price purchasesFees;
    private Price incomingTransfers;
    private Price outgoingTransfers;
    private Price closingStock;
    private Price salesInc;
    private Price salesExTax;
    private Price wastage;
    private Price yield;
    private Price stockTakeVar;
    private Price adjustments;

    public PeriodStockAreaReportItem() {
        this.area = this.createReference(PeriodStockAreaReportItem.Properties.AREA);
        this.openingStock = Price.ZERO_DOLLAR;
        this.purchasesStock = Price.ZERO_DOLLAR;
        this.purchasesFees = Price.ZERO_DOLLAR;
        this.incomingTransfers = Price.ZERO_DOLLAR;
        this.outgoingTransfers = Price.ZERO_DOLLAR;
        this.closingStock = Price.ZERO_DOLLAR;
        this.salesInc = Price.ZERO_DOLLAR;
        this.salesExTax = Price.ZERO_DOLLAR;
        this.wastage = Price.ZERO_DOLLAR;
        this.yield = Price.ZERO_DOLLAR;
        this.stockTakeVar = Price.ZERO_DOLLAR;
        this.adjustments = Price.ZERO_DOLLAR;
    }

    public PeriodStockAreaReportItem(StockArea stockArea, StockTake take) {
        this.area = this.createReference(PeriodStockAreaReportItem.Properties.AREA);
        this.openingStock = Price.ZERO_DOLLAR;
        this.purchasesStock = Price.ZERO_DOLLAR;
        this.purchasesFees = Price.ZERO_DOLLAR;
        this.incomingTransfers = Price.ZERO_DOLLAR;
        this.outgoingTransfers = Price.ZERO_DOLLAR;
        this.closingStock = Price.ZERO_DOLLAR;
        this.salesInc = Price.ZERO_DOLLAR;
        this.salesExTax = Price.ZERO_DOLLAR;
        this.wastage = Price.ZERO_DOLLAR;
        this.yield = Price.ZERO_DOLLAR;
        this.stockTakeVar = Price.ZERO_DOLLAR;
        this.adjustments = Price.ZERO_DOLLAR;
        this.area.set(stockArea);
        this.stockAreaLabel = stockArea != null ? stockArea.getLabel() : "No Area";
        if (take != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(take.getDate());
            cal.set(14, 0);
            this.periodEnd = cal.getTime();
        } else {
            this.periodEnd = null;
        }
    }

    @Transient
    public StockArea getArea() {
        return this.area.get();
    }

    protected void setArea(StockArea value) {
        this.area.set(value);
    }

    @Column(name="stock_area_label")
    public String getStockAreaLabel() {
        return this.stockAreaLabel;
    }

    protected void setStockAreaLabel(String value) {
        this.stockAreaLabel = value;
    }

    @Column(name="period_end")
    @Basic(optional=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getPeriodEnd() {
        return this.periodEnd;
    }

    protected void setPeriodEnd(Date value) {
        this.periodEnd = value;
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.0001")})
    @Column(name="opening_stock")
    public Price getOpeningStock() {
        return this.openingStock;
    }

    public void setOpeningStock(Price newOpeningStock) {
        this.openingStock = newOpeningStock;
    }

    @Transient
    public Price getPurchases() {
        return this.purchasesStock.add(this.purchasesFees);
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.0001")})
    @Column(name="purchases_stock")
    public Price getPurchasesStock() {
        return this.purchasesStock;
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.0001")})
    @Column(name="purchases_fee")
    public Price getPurchasesFees() {
        return this.purchasesFees;
    }

    @Transient
    public Price getTransfers() {
        return this.incomingTransfers.add(this.outgoingTransfers);
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.0001")})
    @Column(name="in_transfers")
    protected Price getIncomingTransfers() {
        return this.incomingTransfers;
    }

    public void setIncomingTransfers(Price transfers) {
        this.incomingTransfers = transfers;
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.0001")})
    @Column(name="out_transfers")
    protected Price getOutgoingTransfers() {
        return this.outgoingTransfers;
    }

    public void setOutgoingTransfers(Price transfers) {
        this.outgoingTransfers = transfers;
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.0001")})
    @Column(name="closing_stock")
    public Price getClosingStock() {
        return this.closingStock;
    }

    public void setClosingStock(Price newClosingStock) {
        this.closingStock = newClosingStock;
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.0001")})
    @Column(name="sales_inc")
    public Price getSalesInc() {
        return this.salesInc;
    }

    public void setSalesInc(Price sales) {
        this.salesInc = sales;
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.0001")})
    @Column(name="sales_ex")
    public Price getSalesExTax() {
        return this.salesExTax;
    }

    public void setSalesExTax(Price newSalesExTax) {
        this.salesExTax = newSalesExTax;
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.0001")})
    @Column(name="wastage")
    public Price getWastage() {
        return this.wastage;
    }

    public void setWastage(Price newWastage) {
        this.wastage = newWastage;
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.0001")})
    @Column(name="yield")
    public Price getYield() {
        return this.yield;
    }

    public void setYield(Price newYield) {
        this.yield = newYield;
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.0001")})
    @Column(name="stocktake_var")
    public Price getStockTakeVar() {
        return this.stockTakeVar;
    }

    public void setStockTakeVar(Price newStockTakeVar) {
        this.stockTakeVar = newStockTakeVar;
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.0001")})
    @Column(name="adjustments")
    public Price getAdjustments() {
        return this.adjustments;
    }

    public void setAdjustments(Price newAdjustments) {
        this.adjustments = newAdjustments;
    }

    @Transient
    public Price getCoGs() {
        return this.getOpeningStock().add(this.getPurchases()).add(this.getTransfers()).subtract(this.getClosingStock());
    }

    @Transient
    public Double getGPPerc() {
        return FinanceUtils.calcGrossProfitMargin(this.getSalesExTax().doubleValue(), this.getCoGs().doubleValue());
    }

    @Transient
    public Price getGP() {
        return new Price(FinanceUtils.calcGrossProfit(this.getSalesExTax().doubleValue(), this.getCoGs().doubleValue()), Price.DEFAULT_ROUND_AMOUNT);
    }

    public void setPurchasesStock(Price price) {
        this.purchasesStock = price;
    }

    public void setPurchasesFees(Price price) {
        this.purchasesFees = price;
    }

    @Transient
    public double getInvTurns() {
        Price averageInventory = this.getOpeningStock().add(this.getClosingStock());
        if ((averageInventory = averageInventory.divide(2)).isZero()) {
            return 0.0;
        }
        return this.getCoGs().divide(averageInventory).doubleValue();
    }

    @Transient
    public Double getCogsPerc() {
        if (this.getSalesExTax().isZero() || this.getCoGs().isZero()) {
            return 0.0;
        }
        return this.getCoGs().multiply(100).divide(this.getSalesExTax()).doubleValue();
    }

    public void add(PeriodStockAreaReportItem anotherItem) {
        this.openingStock = this.openingStock.add(anotherItem.openingStock);
        this.purchasesStock = this.purchasesStock.add(anotherItem.purchasesStock);
        this.purchasesFees = this.purchasesFees.add(anotherItem.purchasesFees);
        this.incomingTransfers = this.incomingTransfers.add(anotherItem.incomingTransfers);
        this.outgoingTransfers = this.outgoingTransfers.add(anotherItem.outgoingTransfers);
        this.closingStock = this.closingStock.add(anotherItem.closingStock);
        this.salesInc = this.salesInc.add(anotherItem.salesInc);
        this.salesExTax = this.salesExTax.add(anotherItem.salesExTax);
        this.wastage = this.wastage.add(anotherItem.wastage);
        this.yield = this.yield.add(anotherItem.yield);
        this.stockTakeVar = this.stockTakeVar.add(anotherItem.stockTakeVar);
        this.adjustments = this.adjustments.add(anotherItem.adjustments);
    }

    public void aggregate(PeriodStockAreaReportItem anotherItem) {
        if (!anotherItem.getStockAreaLabel().equals(this.getStockAreaLabel())) {
            throw new IllegalArgumentException("Cannot aggregate the two period stock reports, differing areas.");
        }
        Price opening = this.openingStock;
        this.add(anotherItem);
        this.openingStock = opening;
        this.closingStock = anotherItem.closingStock;
    }

    public void updateReportValues(PeriodStockAreaReportItem newReport) {
        if (newReport == null) {
            throw new IllegalArgumentException("Cannot set the values from a null report");
        }
        this.openingStock = newReport.openingStock;
        this.purchasesStock = newReport.purchasesStock;
        this.purchasesFees = newReport.purchasesFees;
        this.incomingTransfers = newReport.incomingTransfers;
        this.outgoingTransfers = newReport.outgoingTransfers;
        this.closingStock = newReport.closingStock;
        this.salesInc = newReport.salesInc;
        this.salesExTax = newReport.salesExTax;
        this.wastage = newReport.wastage;
        this.yield = newReport.yield;
        this.stockTakeVar = newReport.stockTakeVar;
        this.adjustments = newReport.adjustments;
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
    }

    @Override
    public void delete() {
        PersistenceManager.delete(this);
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    public static final class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<StockArea> AREA;
        public PropertiedObject.Property<Date> PERIOD_END;
        public PropertiedObject.Property<String> STOCK_AREA_LABEL;
        public PropertiedObject.Property<Price> OPENING_STOCK;
        public PropertiedObject.Property<Price> CLOSING_STOCK;
        public PropertiedObject.Property<Price> PURCHASES_STOCK;
        public PropertiedObject.Property<Price> PURCHASES_FEES;
        public PropertiedObject.Property<Price> INCOMING_TRANSFERS;
        public PropertiedObject.Property<Price> OUTGOING_TRANSFERS;
        public PropertiedObject.Property<Price> SALES_INC;
        public PropertiedObject.Property<Price> SALES_EX_TAX;
        public PropertiedObject.Property<Price> WASTAGE;
        public PropertiedObject.Property<Price> YIELD;
        public PropertiedObject.Property<Price> STOCKTAKE_VAR;
        public PropertiedObject.Property<Price> ADJUSTMENTS;
        public PersistentObject.DerivedProperty<Price> TRANSFERS = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)PeriodStockAreaReportItem.class), "transfers");
        public PersistentObject.DerivedProperty<Price> PURCHASES = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)PeriodStockAreaReportItem.class), "purchases");
        public PersistentObject.DerivedProperty<Double> COGS_PERC = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)PeriodStockAreaReportItem.class), "cogsPerc");
        public PersistentObject.DerivedProperty<Price> COGS = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)PeriodStockAreaReportItem.class), "coGs");
        public PersistentObject.DerivedProperty<Double> GP_PERC = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)PeriodStockAreaReportItem.class), "GPPerc");
        public PersistentObject.DerivedProperty<Price> GP = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)PeriodStockAreaReportItem.class), "GP");
        public PersistentObject.DerivedProperty<Double> INV_TURNS = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)PeriodStockAreaReportItem.class), "invTurns");
    }
}

