/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.periodstock;

import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.annotation.FilterConfig;
import au.com.ordermate.oquery.search.filter.implementation.DateRangeSearchFilter;
import java.util.Date;
import ordermate.database.reports.periodstock.PeriodStockAreaReport;
import ordermate.database.stock.StockTake;

public class PeriodStockAreaReportParams {
    private DateRangeSearchFilter dateFilter = new DateRangeSearchFilter(null, SQLDateType.TIMESTAMP);

    @FilterConfig(name="Date Range", defaultValue="DateRange", dataType=Date.class, dateType=SQLDateType.TIMESTAMP, nullAllowed=false, plural=FilterConfig.Plural.Ranged, priority=true, sequence=1)
    public DateRangeSearchFilter getDateRangeFilter() {
        return this.dateFilter;
    }

    public PeriodStockAreaReport getReport() {
        Date from = (Date)this.dateFilter.getStart();
        Date to = (Date)this.dateFilter.getEnd();
        StockTake takeFrom = StockTake.getFirstStockTakeForDate(from);
        StockTake takeTo = StockTake.getLastStockTakeForDate(to);
        PeriodStockAreaReport report = new PeriodStockAreaReport(takeFrom, takeTo);
        return report;
    }
}

