/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.periodstock;

import ar.com.fdvs.dj.domain.ColumnProperty;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.builders.BuilderException;
import ar.com.fdvs.dj.domain.constants.Page;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.columns.SimpleColumn;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import ordermate.database.reports.periodstock.PeriodStockAreaReport;
import ordermate.database.reports.periodstock.PeriodStockTableModel;
import ordermate.reports.dynamicjasper.OrderMateMinimalistStyle;
import ordermate.reports.dynamicjasper.ReportBuilder;
import ordermate.reports.dynamicjasper.reportbuilder.AbstractReportProvider;

public class PeriodStockAreaReportProvider
extends AbstractReportProvider {
    private PeriodStockAreaReport report;
    private PeriodStockTableModel model;

    public PeriodStockAreaReportProvider(PeriodStockAreaReport report) {
        this.report = report;
    }

    @Override
    public JRRewindableDataSource getDataSource() {
        this.model = new PeriodStockTableModel(this.report, false);
        return new JRTableModelDataSource((TableModel)this.model);
    }

    @Override
    protected DynamicReport getReport() throws BuilderException {
        return this.getBuilder().buildJasperReport();
    }

    @Override
    public ReportBuilder getBuilder() throws BuilderException {
        ReportBuilder builder = new ReportBuilder(new OrderMateMinimalistStyle());
        builder.getReportBuilder().setPageSizeAndOrientation(Page.Page_A4_Landscape());
        builder.setTitle("Period Stock");
        DateFormat format = DateFormat.getDateInstance();
        String subtitle = "From " + format.format(this.report.getStartDate()) + " to " + format.format(this.report.getEnd());
        builder.setSubtitle(subtitle);
        this.model = new PeriodStockTableModel(this.report, false);
        String[] titles = this.model.createColumnTitles();
        for (int i = 0; i < titles.length; ++i) {
            String title = titles[i];
            SimpleColumn col = new SimpleColumn();
            if (i == 0 || i == 8 || i == 9) {
                col.setColumnProperty(new ColumnProperty(title, String.class));
            } else if (i == 14) {
                col.setColumnProperty(new ColumnProperty(title, Double.class));
                if (i != 14) {
                    col.setTextFormatter((Format)NumberFormat.getPercentInstance());
                }
            } else {
                col.setColumnProperty(new ColumnProperty(title, BigDecimal.class));
                col.setTextFormatter((Format)NumberFormat.getCurrencyInstance());
            }
            col.setName(title);
            col.setTitle(title);
            builder.getReportBuilder().addColumn((AbstractColumn)col);
        }
        return builder;
    }

    @Override
    protected String getAdditionalFooterText() {
        return null;
    }
}

