/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.periodstock;

import au.com.ordermate.util.MathsUtils;
import au.com.ordermate.util.Price;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import javax.swing.table.DefaultTableModel;
import ordermate.database.misc.SystemProperty;
import ordermate.database.reports.periodstock.PeriodStockAreaReport;
import ordermate.database.reports.periodstock.PeriodStockAreaReportItem;
import ordermate.database.stock.StockArea;

public class PeriodStockTableModel
extends DefaultTableModel {
    private static final NumberFormat percentFormatter = NumberFormat.getPercentInstance();
    private static final int NUM_COLS = 15;
    public static final int COL_AREA_NAME = 0;
    public static final int COL_OPENING = 1;
    public static final int COL_PURCHASES = 2;
    public static final int COL_TRANSFERS = 3;
    public static final int COL_CLOSING = 4;
    public static final int COL_COGS = 5;
    public static final int COL_SALES = 6;
    public static final int COL_SALES_EX = 7;
    public static final int COL_GP_PERCENT = 8;
    public static final int COL_COGS_PERCENT = 9;
    public static final int COL_WASTAGE = 10;
    public static final int COL_YIELD = 11;
    public static final int COL_STOCKTAKE_VAR = 12;
    public static final int COL_ADJUST = 13;
    public static final int COL_INVENTORY_TURNS = 14;
    private Object[] totals;

    public PeriodStockTableModel(PeriodStockAreaReport report) {
        this(report, true);
    }

    public PeriodStockTableModel(PeriodStockAreaReport report, boolean asPrice) {
        percentFormatter.setMinimumFractionDigits(2);
        percentFormatter.setMaximumFractionDigits(2);
        List<PeriodStockAreaReportItem> reportItems = report.getReportItems(StockArea.getStockAreas());
        Object[] columnTitles = this.createColumnTitles();
        this.setColumnIdentifiers(columnTitles);
        this.setRowCount(reportItems.size());
        int rowIndex = 0;
        for (PeriodStockAreaReportItem item : reportItems) {
            this.setValueAt(item.getStockAreaLabel(), rowIndex, 0);
            this.setValueAt(asPrice ? item.getOpeningStock() : item.getOpeningStock().toBigDecimal(), rowIndex, 1);
            this.setValueAt(asPrice ? item.getPurchases() : item.getPurchases().toBigDecimal(), rowIndex, 2);
            this.setValueAt(asPrice ? item.getTransfers() : item.getTransfers().toBigDecimal(), rowIndex, 3);
            this.setValueAt(asPrice ? item.getClosingStock() : item.getClosingStock().toBigDecimal(), rowIndex, 4);
            this.setValueAt(asPrice ? item.getCoGs() : item.getCoGs().toBigDecimal(), rowIndex, 5);
            this.setValueAt(asPrice ? item.getSalesInc() : item.getSalesInc().toBigDecimal(), rowIndex, 6);
            this.setValueAt(asPrice ? item.getSalesExTax() : item.getSalesExTax().toBigDecimal(), rowIndex, 7);
            this.setValueAt(percentFormatter.format(this.round(item.getGPPerc() / 100.0, 4)), rowIndex, 8);
            this.setValueAt(percentFormatter.format(this.round(item.getCogsPerc() / 100.0, 4)), rowIndex, 9);
            this.setValueAt(asPrice ? item.getWastage() : item.getWastage().toBigDecimal(), rowIndex, 10);
            this.setValueAt(asPrice ? item.getYield() : item.getYield().toBigDecimal(), rowIndex, 11);
            this.setValueAt(asPrice ? item.getStockTakeVar() : item.getStockTakeVar().toBigDecimal(), rowIndex, 12);
            this.setValueAt(asPrice ? item.getAdjustments() : item.getAdjustments().toBigDecimal(), rowIndex, 13);
            this.setValueAt(this.round(item.getInvTurns(), 2), rowIndex, 14);
            ++rowIndex;
        }
        this.totals = new Object[15];
        if (this.getRowCount() > 0) {
            DecimalFormat format = new DecimalFormat("0.00");
            for (int column = 0; column < this.totals.length; ++column) {
                if (!(this.getValueAt(0, column) instanceof Number)) continue;
                double colTotal = 0.0;
                for (int row = 0; row < reportItems.size(); ++row) {
                    Object val = this.getValueAt(row, column);
                    if (!(val instanceof Number)) continue;
                    colTotal += ((Number)val).doubleValue();
                }
                this.totals[column] = asPrice ? new Price(colTotal, 0.01) : new BigDecimal(format.format(colTotal));
            }
            double totalSalesEx = ((Number)this.totals[7]).doubleValue();
            double totalCOGS = ((Number)this.totals[5]).doubleValue();
            double totalGP = totalSalesEx - totalCOGS;
            double gpPercent = this.round(totalSalesEx != 0.0 ? totalGP / totalSalesEx : 0.0, 4);
            this.totals[8] = percentFormatter.format(gpPercent);
            double cogsPerc = totalCOGS / totalSalesEx;
            this.totals[9] = percentFormatter.format(this.round(cogsPerc, 4));
            this.totals[14] = "";
        }
    }

    public String[] createColumnTitles() {
        return new String[]{"Area", "Opening Stock", "Purchases", "Transfers", "Closing Stock", "COGS", "Sales", "Sales Ex " + SystemProperty.getInstance().getBaseTaxLabel(), "% Profit", "% COGS", "Wastage", "Yield", "Stocktake Var", "Adjust", "Inv. Turns"};
    }

    public Object[] getTotals() {
        return this.totals;
    }

    private double round(double value, int decimalPlaces) {
        return MathsUtils.roundDoubleToDecPlaces(value, decimalPlaces);
    }
}

