/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.periodtrend;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.annotation.FilterConfig;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectSearchFilter;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.search.IRangedSearchFilter;
import au.com.ordermate.search.ISingleValueSearchFilter;
import au.com.ordermate.search.abstracts.SingleValueSearchFilter;
import au.com.ordermate.search.filter.BooleanSearchFilter;
import au.com.ordermate.search.offset.DateOffsetFunction;
import au.com.ordermate.util.DateTimeUtils;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import ordermate.OrderMate;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.config.report.ReportGroup;
import ordermate.database.config.report.ReportProperty;
import ordermate.database.queries.sales.SalesHistoryQueries;
import ordermate.database.searchers.reports.sales.time.SalesHistoryReportSearcher;
import ordermate.reports.dynamicjasper.PeriodReportAdapter;

public class PeriodTrendReportCompiler {
    static String TRIM_BLOCK = "TrimBlock";
    private SalesHistoryReportSearcher searcher;
    private int minuteFactor = 15;
    private SingleValueSearchFilter<TimeBlock> timeBlockFilter = new ObjectSearchFilter<TimeBlock>(null);
    private SingleValueSearchFilter<Boolean> cumulativeFilter = new BooleanSearchFilter(null);
    private PeriodReportAdapter period;
    private boolean cumulative;

    public PeriodTrendReportCompiler(SalesHistoryReportSearcher theSearcher) {
        this.searcher = theSearcher;
        if (theSearcher.getPeriod() != null) {
            this.setPeriod(theSearcher.getPeriod());
        } else {
            this.setPeriod(PeriodReportAdapter.MONTHLY);
        }
        this.searcher.getShiftFilter().clearSearch();
        this.searcher.getTradingDayDateRangeFilter().setStart(DateTimeUtils.getThreeMonthsAgo());
        this.searcher.getTradingDayDateRangeFilter().setEnd(new Date());
    }

    public SalesHistoryReportSearcher getSearcher() {
        return this.searcher;
    }

    public TableModel compile() {
        this.searcher.setPeriod(this.getPeriod());
        int minutes = 60 * this.getTimeBlockMin();
        this.cumulative = this.isCumulative();
        DateOffsetFunction offset = this.period.getDateOffset();
        if (PeriodReportAdapter.WEEK_ENDING.equals(this.period)) {
            this.getDateRangeFilter().setStart(offset.calcOffset(this.getDateRangeFilter().getStart()));
            this.getDateRangeFilter().setEnd(offset.calcStart(this.getDateRangeFilter().getEnd()));
        } else {
            this.getDateRangeFilter().setStart(offset.calcStart(this.getDateRangeFilter().getStart()));
            this.getDateRangeFilter().setEnd(offset.calcOffset(offset.calcStart(this.getDateRangeFilter().getEnd())));
        }
        ObjectQuery query = this.searcher.getObjectQuery();
        query.selectFunc(SalesHistoryQueries.getTradingDayGroupByFunction(this.period).toString() + "(finance_trading_day.day) as period_block").selectFunc("floor(time_to_sec(sales_item_quantity.creation_time) / (" + minutes + ")) as time_block").groupBy("time_block");
        DefaultTableModel model = new DefaultTableModel();
        this.makeResultTable(model, PersistenceManager.getPersistenceDelegate().executeQuery(query.toString(), null));
        return model;
    }

    private void makeResultTable(DefaultTableModel model, Object[][] results) {
        ArrayList<String> colNames = new ArrayList<String>();
        ArrayList<Date> periods = new ArrayList<Date>();
        colNames.add("Time Block");
        DateOffsetFunction offset = this.period.getDateOffset();
        Date start = this.getDateRangeFilter().getStart();
        Date end = this.getDateRangeFilter().getEnd();
        Calendar cal = Calendar.getInstance();
        if (PeriodReportAdapter.WEEK_ENDING.equals(this.getPeriod())) {
            cal.setTime(offset.calcOffset(start));
        } else {
            cal.setTime(offset.calcOffset(offset.calcStart(start)));
        }
        DateTimeUtils.clearTimePart(cal);
        Date next = cal.getTime();
        boolean hasOverlappingWeek = false;
        while (next.compareTo(end) <= 0) {
            Date theDate = cal.getTime();
            periods.add(theDate);
            colNames.add(this.period.formatDateForDisplay(theDate));
            if (PeriodReportAdapter.WEEK_ENDING.equals(this.period)) {
                Date lastDayOfTheWeek = offset.calcStart(cal.getTime());
                Calendar lastDayOfTheWeekCal = Calendar.getInstance();
                lastDayOfTheWeekCal.setTime(lastDayOfTheWeek);
                if (cal.get(1) != lastDayOfTheWeekCal.get(1)) {
                    periods.add(lastDayOfTheWeek);
                    hasOverlappingWeek = true;
                }
                lastDayOfTheWeekCal.add(6, 1);
                next = offset.calcOffset(lastDayOfTheWeekCal.getTime());
                cal.setTime(next);
                continue;
            }
            cal.add(6, 1);
            next = offset.calcOffset(cal.getTime());
            cal.setTime(next);
        }
        Collections.sort(periods);
        colNames.add(this.cumulative ? "Avg" : "Total");
        Object[][] data = this.fillTable(results, periods, hasOverlappingWeek);
        model.setDataVector(data, colNames.toArray(new String[colNames.size()]));
    }

    private Object[][] fillTable(Object[][] results, List<Date> periods, boolean hasOverlappingWeek) {
        int SALES = 2;
        int PERIOD_BLOCK = 3;
        int TIME_BLOCK = 4;
        StringBuilder SB = new StringBuilder();
        SB.append("SELECT ");
        String function = SalesHistoryQueries.getTradingDayGroupByFunction(this.period).toString();
        for (int i = 0; i < periods.size(); ++i) {
            SB.append(function).append("(?)");
            if (i >= periods.size() - 1) continue;
            SB.append(",\r\n");
        }
        Object[][] data = null;
        if (PeriodReportAdapter.DAILY.equals(this.getPeriod())) {
            int i;
            HashMap<Date, Integer> dateColumnIndexMap = new HashMap<Date, Integer>();
            for (i = 0; i < periods.size(); ++i) {
                Date date = periods.get(i);
                date = DateTimeUtils.clearTimePart(date);
                dateColumnIndexMap.put(date, i);
            }
            data = new Object[1440 / this.minuteFactor][periods.size() + 2];
            for (i = 0; i < data.length; ++i) {
                data[i][0] = DateTimeUtils.toHoursMinutes((long)(i * 60 * this.minuteFactor) * 1000L);
            }
            for (Object[] result : results) {
                int periodIndex;
                Date periodDate = DateTimeUtils.clearTimePart((Date)result[1]);
                int timeBlock = ((Number)result[TIME_BLOCK]).intValue();
                Number value = (Number)data[timeBlock][periodIndex = 1 + (Integer)dateColumnIndexMap.get(periodDate)];
                BigDecimal currentValue = value != null ? new BigDecimal(value.toString()) : BigDecimal.ZERO;
                BigDecimal salesToAdd = new BigDecimal(result[SALES].toString());
                data[timeBlock][periodIndex] = currentValue.add(salesToAdd);
            }
        } else {
            Object[][] periodBlocks = PersistenceManager.getPersistenceDelegate().executeQuery(SB.toString(), periods.toArray(new Date[periods.size()]));
            Map<Integer, Integer> periodIndexMap = this.createPeriodIndexMap(periodBlocks, hasOverlappingWeek);
            int periodColumnCount = hasOverlappingWeek ? new HashSet<Integer>(periodIndexMap.values()).size() : periods.size();
            data = new Object[1440 / this.minuteFactor][periodColumnCount + 2];
            for (int i = 0; i < data.length; ++i) {
                data[i][0] = DateTimeUtils.toHoursMinutes((long)(i * 60 * this.minuteFactor) * 1000L);
            }
            for (Object[] result : results) {
                int periodIndex;
                Integer periodBlock = (Integer)result[PERIOD_BLOCK];
                int timeBlock = ((Number)result[TIME_BLOCK]).intValue();
                Number value = (Number)data[timeBlock][periodIndex = 1 + periodIndexMap.get(periodBlock)];
                BigDecimal currentValue = value != null ? new BigDecimal(value.toString()) : BigDecimal.ZERO;
                BigDecimal salesToAdd = new BigDecimal(result[SALES].toString());
                data[timeBlock][periodIndex] = currentValue.add(salesToAdd);
            }
        }
        data = this.trimData(data);
        this.accumulate(data);
        return data;
    }

    private Map<Integer, Integer> createPeriodIndexMap(Object[][] periodBlocks, boolean hasOverlappingWeek) {
        HashMap<Integer, Integer> periodIndex = new HashMap<Integer, Integer>();
        if (PeriodReportAdapter.WEEK_ENDING.equals(this.getPeriod()) && hasOverlappingWeek) {
            int columnIndex = -1;
            int previousPeriod = 0;
            for (int i = 0; i < periodBlocks[0].length; ++i) {
                int currentPeriod = ((Number)periodBlocks[0][i]).intValue();
                if (currentPeriod > previousPeriod) {
                    ++columnIndex;
                }
                periodIndex.put(currentPeriod, columnIndex);
                previousPeriod = currentPeriod;
            }
        } else {
            for (int i = 0; i < periodBlocks[0].length; ++i) {
                periodIndex.put(((Number)periodBlocks[0][i]).intValue(), i);
            }
        }
        return periodIndex;
    }

    private void accumulate(Object[][] data) {
        int TOTAL = data[0].length - 1;
        int NUM_PERIODS = data[0].length - 2;
        for (int time = 0; time < data.length; ++time) {
            double total = 0.0;
            for (int periodCol = 1; periodCol < NUM_PERIODS + 1; ++periodCol) {
                if (this.cumulative && time != 0 && data[time - 1][periodCol] != null) {
                    data[time][periodCol] = this.getAsNumber(data[time][periodCol]) + this.getAsNumber(data[time - 1][periodCol]);
                }
                total += this.getAsNumber(data[time][periodCol]);
            }
            data[time][TOTAL] = !this.cumulative ? total : total / (double)NUM_PERIODS;
        }
        DecimalFormat format = new DecimalFormat("#0.00");
        for (int time = 0; time < data.length; ++time) {
            for (int periodCol = 1; periodCol < NUM_PERIODS + 2; ++periodCol) {
                Number val = (Number)data[time][periodCol];
                if (val == null) continue;
                data[time][periodCol] = format.format(val);
            }
        }
    }

    private double getAsNumber(Object object) {
        return object == null ? 0.0 : ((Number)object).doubleValue();
    }

    private Object[][] trimData(Object[][] data) {
        String trims = ReportProperty.find(ReportGroup.PeriodTrend, TRIM_BLOCK).getStringValue(null);
        if (trims != null) {
            int separator = trims.indexOf(",");
            String startBlock = null;
            String endBlock = null;
            if (separator >= 0) {
                if (separator > 0) {
                    startBlock = trims.substring(0, separator);
                }
                endBlock = trims.substring(separator + 1);
            } else {
                startBlock = trims;
            }
            int start = 0;
            int end = data.length;
            for (int i = 0; i < data.length; ++i) {
                if (start == 0 && data[i][0].equals(startBlock)) {
                    start = i;
                }
                if (!data[i][0].equals(endBlock)) continue;
                end = i + 1;
                if (end <= data.length) break;
                end = data.length;
                break;
            }
            Object[][] newData = new Object[data.length - start - (data.length - end)][];
            for (int i = 0; i < newData.length; ++i) {
                newData[i] = data[i + start];
            }
            return newData;
        }
        return data;
    }

    public void setMinuteFactor(int value) {
        this.minuteFactor = value;
    }

    public void setPeriod(PeriodReportAdapter period) {
        this.period = period;
    }

    public void setCumulative(boolean value) {
        this.cumulative = value;
    }

    public boolean isCumulative() {
        if (this.cumulativeFilter.hasSearchValue()) {
            this.cumulative = this.cumulativeFilter.getSearchValue();
        }
        return this.cumulative;
    }

    @FilterConfig(name="Is Cumulative", dataType=Boolean.class, nullAllowed=true, plural=FilterConfig.Plural.Single, priority=true, sequence=3)
    public ISingleValueSearchFilter<Boolean> getCumulativeFilter() {
        return this.cumulativeFilter;
    }

    @FilterConfig(name="Date Range", dataType=Date.class, dateType=SQLDateType.DATE, plural=FilterConfig.Plural.Ranged, nullAllowed=false, priority=true, sequence=1)
    public IRangedSearchFilter<Date> getDateRangeFilter() {
        return this.searcher.getDateRangeFilter();
    }

    @FilterConfig(name="Time Block", dataType=TimeBlock.class, plural=FilterConfig.Plural.Single, nullAllowed=true, priority=true, sequence=2)
    public ISingleValueSearchFilter<TimeBlock> getTimeBlockFilter() {
        return this.timeBlockFilter;
    }

    @FilterConfig(name="Sales Location", dataType=SalesLocation.class, plural=FilterConfig.Plural.Multiple, sequence=10)
    public MultiOptionSearchFilter<SalesLocation> getSalesLocationFilter() {
        return this.searcher.getSalesLocationFilter();
    }

    public int getTimeBlockMin() {
        if (this.timeBlockFilter.hasSearchValue()) {
            this.minuteFactor = this.timeBlockFilter.getSearchValue().getMins();
        }
        return this.minuteFactor;
    }

    public PeriodReportAdapter getPeriod() {
        return this.period;
    }

    public int getMinuteFactor() {
        return this.minuteFactor;
    }

    public static enum TimeBlock {
        ONE_HOUR("1 hour", 60),
        HALF_HOUR("0.5 hour", 30),
        TWENTY_MINS("20 minutes", 20),
        FIFTEEN_MIN("15 minutes", 15),
        TEN_MIN("10 minutes", 10),
        FIVE_MIN("5 minutes", 5),
        ONE_MIN("1 minute", 1),
        TWO_HOURS("2 hours", 120),
        FOUR_HOURS("4 hours", 240),
        SIX_HOURS("6 hours", 360),
        EIGHT_HOURS("8 hours", 480);

        private String desc;
        private int mins;

        private TimeBlock(String desc, int mins) {
            this.desc = desc;
            this.mins = mins;
        }

        public String getDesc() {
            return this.desc;
        }

        public int getMins() {
            return this.mins;
        }

        public String toString() {
            return this.desc;
        }

        public static int minutes(String key) {
            try {
                TimeBlock timeBlock = TimeBlock.valueOf(key);
                return timeBlock.getMins();
            }
            catch (Exception e) {
                OrderMate.LOG.error("Undefined type(" + key + ") for TimeBlock enum, the " + FIFTEEN_MIN.getDesc() + " time block will be set", (Throwable)e);
                return FIFTEEN_MIN.getMins();
            }
        }
    }
}

